/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.dump;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.dump.Dumpable;

public class Dumper {
    private int maxSetSize = 10;
    private boolean skipStatic = true;
    private boolean skipNull = true;
    private Map dumpedObjects = new HashMap();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public void dump(Object object) {
        this.dump(null, object, new PrintWriter(System.out, true), 0);
    }

    public void dump(String title, Object o) {
        this.dump(title, o, new PrintWriter(System.out, true), 0);
    }

    public void dump(Object object, Writer writer) {
        this.dump(null, object, writer, 0);
    }

    public void dump(Object object, Writer writer, int indent) {
        this.dump(null, object, writer, indent);
    }

    public void dump(String title, Object o, Writer writer, int indent) {
        this.write(writer, indent);
        try {
            if (title != null) {
                this.write(writer, title);
                this.write(writer, " ");
            }
            if (o == null) {
                this.writeln(writer, "null");
                return;
            }
            Class<?> cls = o.getClass();
            if (cls.isPrimitive() || cls.equals(Boolean.class) || cls.equals(Character.class) || cls.equals(Byte.class) || cls.equals(Short.class) || cls.equals(Integer.class) || cls.equals(Long.class) || cls.equals(Float.class) || cls.equals(Double.class) || cls.equals(Void.class) || cls.equals(String.class)) {
                this.writeln(writer, o.toString());
                return;
            }
            this.write(writer, ReflectUtil.getPrintableClassName(cls));
            this.writeln(writer, ":");
            if (this.dumpedObjects.get(o) != null) {
                this.writeln(writer, "(dumped) " + o.toString(), indent + 1);
                return;
            }
            this.dumpedObjects.put(o, o);
            if (o instanceof Dumpable) {
                ((Dumpable)o).dump(writer, indent + 1);
                return;
            }
            if (o instanceof Collection) {
                int i;
                Collection collection = (Collection)o;
                Iterator it = collection.iterator();
                int size = collection.size();
                for (i = 0; i < size; ++i) {
                    if (i >= this.maxSetSize) {
                        this.writeln(writer, "[...]", indent);
                        break;
                    }
                    Object tmp = it.next();
                    this.dump("[" + i + "]", tmp, writer, indent + 1);
                }
                if (i > 0) {
                    this.writeln(writer);
                }
                return;
            }
            if (o instanceof Iterator) {
                Iterator it = (Iterator)o;
                int i = 0;
                while (it.hasNext()) {
                    if (i >= this.maxSetSize) {
                        this.writeln(writer, "[...]", indent);
                        break;
                    }
                    Object tmp = it.next();
                    this.dump("[" + i + "]", tmp, writer, indent + 1);
                    ++i;
                }
                if (i > 0) {
                    this.writeln(writer);
                }
                return;
            }
            if (cls.isArray()) {
                int i;
                int size = Array.getLength(o);
                for (i = 0; i < size; ++i) {
                    if (i >= this.maxSetSize) {
                        this.writeln(writer, "[...]", indent);
                        break;
                    }
                    Object tmp = Array.get(o, i);
                    this.dump("[" + i + "]", tmp, writer, indent + 1);
                }
                if (i > 0) {
                    this.writeln(writer);
                }
                return;
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                int i = 0;
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    if (i++ >= this.maxSetSize) {
                        this.writeln(writer, "[...]", indent);
                        break;
                    }
                    Object key = it.next();
                    Object value = map.get(key);
                    this.dump("[" + key.toString() + "]", value, writer, indent + 1);
                }
                if (i > 0) {
                    this.writeln(writer);
                }
                return;
            }
            this.dumpMembers(o, o.getClass(), writer, indent + 1);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void dumpMembers(Object o, Class cls, Writer writer, int indent) {
        if (o == null || cls == Object.class) {
            return;
        }
        try {
            AccessibleObject[] fields = cls.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length; ++i) {
                AccessibleObject field = fields[i];
                int mod = ((Field)field).getModifiers();
                if (this.skipStatic && Modifier.isStatic(mod) || Modifier.isStatic(mod) && Modifier.isFinal(mod) || Modifier.isTransient(mod)) continue;
                String name = ((Field)field).getName();
                try {
                    Object value = ((Field)field).get(o);
                    if (this.skipNull && value == null || o instanceof Class) continue;
                    this.dump(name + " =", value, writer, indent);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Dumper: IllegalArgumentException accessing field " + name);
                    ExceptionUtil.printTrace(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    System.err.println("Dumper: IllegalArgumentException accessing field " + name);
                    ExceptionUtil.printTrace(e);
                }
            }
        }
        catch (SecurityException e) {
            System.err.println("Dumper: IllegalArgumentException accessing field list of " + ReflectUtil.getPrintableClassName(cls));
            ExceptionUtil.printTrace(e);
        }
        this.dumpMembers(o, cls.getSuperclass(), writer, indent);
    }

    public void write(Writer writer, int indent) {
        try {
            for (int i = 0; i < indent; ++i) {
                writer.write(9);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void write(Writer writer, String s) throws IOException {
        writer.write(s);
    }

    protected void write(Writer writer, String s, int indent) throws IOException {
        this.write(writer, indent);
        this.write(writer, s);
    }

    protected void writeln(Writer writer) throws IOException {
        this.writeln(writer, null);
    }

    protected void writeln(Writer writer, String s) throws IOException {
        if (s != null) {
            writer.write(s);
        }
        writer.write(LINE_SEPARATOR);
        writer.flush();
    }

    protected void writeln(Writer writer, String s, int indent) throws IOException {
        this.write(writer, indent);
        this.writeln(writer, s);
    }

    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    public void setMaxSetSize(int maxSetSizeArg) {
        this.maxSetSize = maxSetSizeArg;
    }

    public boolean getSkipStatic() {
        return this.skipStatic;
    }

    public void setSkipStatic(boolean skipStaticArg) {
        this.skipStatic = skipStaticArg;
    }

    public boolean getSkipNull() {
        return this.skipNull;
    }

    public void setSkipNull(boolean skipNullArg) {
        this.skipNull = skipNullArg;
    }
}

