/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.generic.msgcontainer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openbp.common.generic.msgcontainer.MsgContainer;
import org.openbp.common.generic.msgcontainer.MsgItem;
import org.openbp.common.util.iterator.EmptyIterator;

public class StandardMsgContainer
implements MsgContainer,
Serializable {
    private List msgList;

    @Override
    public void addMsg(Object source, String msg, Object[] args) {
        this.addMsg("Error", source, msg, args);
    }

    @Override
    public void addMsg(Object source, String msg) {
        this.addMsg(source, msg, null);
    }

    @Override
    public void addMsg(String msgType, Object source, String msg, Object[] args) {
        MsgItem item = new MsgItem(msgType, source, msg, args);
        this.addMsg(item);
    }

    @Override
    public void addMsg(String msgType, Object source, String msg) {
        this.addMsg(msgType, source, msg, null);
    }

    public String toString() {
        if (this.msgList != null) {
            StringBuffer sb = null;
            for (MsgItem msgItem : this.msgList) {
                String msg = msgItem.getFormattedMsgWithSource();
                if (msg == null) continue;
                if (sb == null) {
                    sb = new StringBuffer();
                } else {
                    sb.append('\n');
                }
                sb.append(msg);
            }
            if (sb != null) {
                return sb.toString();
            }
        }
        return "";
    }

    public boolean isEmpty() {
        return this.msgList == null;
    }

    public Iterator getMsgs() {
        if (this.msgList == null) {
            return EmptyIterator.getInstance();
        }
        return this.msgList.iterator();
    }

    public List getList() {
        return this.msgList;
    }

    public void addMsg(MsgItem msg) {
        if (this.msgList == null) {
            this.msgList = new ArrayList();
        }
        this.msgList.add(msg);
    }

    public void clearMsgs() {
        this.msgList = null;
    }
}

