/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.generic.propertybrowser;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openbp.common.ReflectUtil;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.common.generic.propertybrowser.PropertyDescriptor;
import org.openbp.common.io.xml.XMLDriver;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.resource.ResourceMgr;
import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.string.StringUtil;
import org.springframework.core.io.Resource;

public final class ObjectDescriptorMgr {
    public static final int ODM_THROW_ERROR = 1;
    public static final int ODM_EXCLUDE_CUSTOM = 2;
    private Map descriptorCache = new HashMap();
    private Map customDescriptors;
    private String customDescriptorResourcePath;
    private static ObjectDescriptorMgr singletonInstance;

    public static synchronized ObjectDescriptorMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ObjectDescriptorMgr();
        }
        return singletonInstance;
    }

    private ObjectDescriptorMgr() {
    }

    public ObjectDescriptor getDescriptor(Class cls, int flags) throws XMLDriverException {
        int workFlags = flags & 0xFFFFFFFE;
        ObjectDescriptor od = this.getDescriptorForClass(cls, workFlags);
        if (od == null) {
            Class superClass;
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length && (od = this.getDescriptorForClass(interfaces[i], workFlags)) == null; ++i) {
            }
            if (od == null && (superClass = cls.getSuperclass()) != null) {
                od = this.getDescriptor(superClass, workFlags);
            }
        }
        if (od == null && (flags & 1) != 0) {
            throw new XMLDriverException("Object descriptor resource not found for class '" + cls.getName() + "'");
        }
        if (od != null) {
            this.descriptorCache.put(cls, od);
        } else {
            this.descriptorCache.put(cls, new Boolean(false));
        }
        return od;
    }

    private ObjectDescriptor getDescriptorForClass(Class cls, int flags) throws XMLDriverException {
        String className = cls.getName();
        if (className.startsWith("java.")) {
            return null;
        }
        ObjectDescriptor descriptor = null;
        if (this.customDescriptors != null && (flags & 2) == 0 && (descriptor = (ObjectDescriptor)this.customDescriptors.get(cls)) != null) {
            this.resolveProperties(descriptor, cls);
            return descriptor;
        }
        Object o = this.descriptorCache.get(cls);
        if (o instanceof ObjectDescriptor) {
            return (ObjectDescriptor)o;
        }
        if (o instanceof Boolean) {
            return null;
        }
        int index = className.lastIndexOf(46);
        String descriptorFileName = className.substring(index + 1);
        InputStream is = cls.getResourceAsStream(descriptorFileName = descriptorFileName + "Prop.xml");
        if (is == null) {
            this.descriptorCache.put(cls, new Boolean(false));
            if ((flags & 1) != 0) {
                throw new XMLDriverException("Object descriptor resource '" + descriptorFileName + "' not found for class '" + className + "'");
            }
            return null;
        }
        try {
            descriptor = (ObjectDescriptor)XMLDriver.getInstance().deserializeStream(ObjectDescriptor.class, is);
        }
        catch (XMLDriverException pe) {
            this.descriptorCache.put(cls, new Boolean(false));
            throw new XMLDriverException("Error loading object descriptor resource for class '" + className + "'", pe);
        }
        descriptor.setObjectClass(cls);
        descriptor.setObjectClassName(cls.getName());
        this.descriptorCache.put(cls, descriptor);
        this.resolveProperties(descriptor, cls);
        return descriptor;
    }

    public void clearCache() {
        this.descriptorCache.clear();
    }

    public String getCustomDescriptorResourcePath() {
        return this.customDescriptorResourcePath;
    }

    public void setCustomDescriptorResourcePath(String customDescriptorResourcePath) {
        this.customDescriptorResourcePath = customDescriptorResourcePath;
    }

    public void loadCustomDescriptorSet(String customDescriptorSetName) throws XMLDriverException {
        this.clearCache();
        this.customDescriptors = null;
        if (this.customDescriptorResourcePath == null) {
            return;
        }
        this.customDescriptorResourcePath = StringUtil.normalizeDir(this.customDescriptorResourcePath);
        this.loadCustomDescriptors(this.customDescriptorResourcePath);
        if (customDescriptorSetName != null) {
            this.loadCustomDescriptors(this.customDescriptorResourcePath + "/" + customDescriptorSetName);
        }
    }

    public void loadCustomDescriptors(String resourcePath) throws XMLDriverException {
        ResourceMgr resMgr = ResourceMgr.getDefaultInstance();
        String resourcePattern = resourcePath + "/*.xml";
        Resource[] resources = null;
        try {
            resources = resMgr.findResources(resourcePattern);
        }
        catch (ResourceMgrException e) {
            String msg = LogUtil.error(this.getClass(), "No custom object descriptors found in resource location $0.", resourcePath);
            throw new XMLDriverException(msg);
        }
        if (resources.length == 0) {
            return;
        }
        XMLDriver xmlDriver = XMLDriver.getInstance();
        for (int i = 0; i < resources.length; ++i) {
            ObjectDescriptor descriptor = null;
            String resourceName = resources[i].getDescription().toString();
            try {
                descriptor = (ObjectDescriptor)xmlDriver.deserializeFile(ObjectDescriptor.class, resourceName);
            }
            catch (XMLDriverException e) {
                LogUtil.error(this.getClass(), "Error loading custom object descriptor $0.", resourceName, e);
                continue;
            }
            try {
                descriptor = (ObjectDescriptor)xmlDriver.deserializeResource(ObjectDescriptor.class, resources[i]);
            }
            catch (XMLDriverException e) {
                LogUtil.error(this.getClass(), "Error loading custom object descriptor $0.", resourceName, e);
                continue;
            }
            descriptor.setCustomDescriptor(true);
            String className = descriptor.getObjectClassName();
            Class cls = ReflectUtil.loadClass(className);
            if (cls == null) {
                LogUtil.error(this.getClass(), "Can't find class $0 specified in custom object descriptor file $1.", className, resourceName);
                continue;
            }
            if (this.customDescriptors == null) {
                this.customDescriptors = new HashMap();
            }
            this.customDescriptors.put(cls, descriptor);
        }
    }

    private void resolveProperties(ObjectDescriptor descriptor, Class cls) throws XMLDriverException {
        if (descriptor.isPropertiesResolved()) {
            return;
        }
        List baseDescriptors = null;
        boolean baseDescriptorsBuilt = false;
        if (descriptor.getValidatorClassName() == null) {
            baseDescriptors = this.buildBaseDescriptorList(cls, descriptor.isCustomDescriptor());
            baseDescriptorsBuilt = true;
            if (baseDescriptors != null) {
                int n = baseDescriptors.size();
                for (int i = 0; i < n; ++i) {
                    ObjectDescriptor baseDescriptor = (ObjectDescriptor)baseDescriptors.get(i);
                    if (baseDescriptor.getValidatorClassName() == null) continue;
                    descriptor.setValidatorClassName(baseDescriptor.getValidatorClassName());
                    descriptor.setValidatorClass(baseDescriptor.getValidatorClass());
                    break;
                }
            }
        }
        Iterator it = descriptor.getProperties();
        while (it.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)it.next();
            boolean incomplete = pd.getDisplayName() == null || pd.getDescription() == null || pd.getEditorClassName() == null && pd.getComplexProperty() == null && pd.getCollectionDescriptor() == null;
            if (!incomplete) continue;
            if (!baseDescriptorsBuilt) {
                baseDescriptors = this.buildBaseDescriptorList(cls, descriptor.isCustomDescriptor());
                baseDescriptorsBuilt = true;
            }
            boolean foundBaseProperty = false;
            if (baseDescriptors != null) {
                String name = pd.getName();
                int n = baseDescriptors.size();
                for (int i = 0; i < n; ++i) {
                    ObjectDescriptor baseDescriptor = (ObjectDescriptor)baseDescriptors.get(i);
                    PropertyDescriptor pdBase = baseDescriptor.getProperty(name);
                    if (pdBase == null) continue;
                    pd.copyNonNull(pdBase);
                    foundBaseProperty = true;
                    break;
                }
            }
            if (foundBaseProperty) continue;
            it.remove();
        }
        descriptor.setPropertiesResolved(true);
    }

    private List buildBaseDescriptorList(Class cls, boolean includeSelf) throws XMLDriverException {
        ObjectDescriptor od;
        Class superClass;
        ObjectDescriptor od2;
        ArrayList<ObjectDescriptor> baseDescriptors = null;
        if (includeSelf && (od2 = this.getDescriptor(cls, 2)) != null) {
            if (baseDescriptors == null) {
                baseDescriptors = new ArrayList<ObjectDescriptor>();
            }
            baseDescriptors.add(od2);
        }
        if ((superClass = cls.getSuperclass()) != null && (od = this.getDescriptor(superClass, 0)) != null) {
            if (baseDescriptors == null) {
                baseDescriptors = new ArrayList();
            }
            baseDescriptors.add(od);
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ObjectDescriptor od3 = this.getDescriptor(interfaces[i], 0);
            if (od3 == null) continue;
            if (baseDescriptors == null) {
                baseDescriptors = new ArrayList();
            }
            baseDescriptors.add(od3);
        }
        return baseDescriptors;
    }
}

