/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.generic.propertybrowser;

import org.openbp.common.ReflectUtil;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.generic.propertybrowser.CollectionDescriptor;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.common.generic.propertybrowser.ObjectDescriptorMgr;
import org.openbp.common.io.xml.XMLDriverException;

public class PropertyDescriptor
extends DisplayObjectImpl {
    private String group;
    private boolean required;
    private boolean readOnly;
    private boolean expanded;
    private String validatorClassName;
    private String editorClassName;
    private String editorParamString;
    private ObjectDescriptor complexProperty;
    private CollectionDescriptor collectionDescriptor;
    private Class validatorClass;
    private Class editorClass;
    private Object editorParam;

    @Override
    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        super.copyFrom(source, copyMode);
        PropertyDescriptor src = (PropertyDescriptor)source;
        this.group = src.group;
        this.required = src.required;
        this.readOnly = src.readOnly;
        this.expanded = src.expanded;
        this.validatorClassName = src.validatorClassName;
        this.editorClassName = src.editorClassName;
        this.editorParamString = src.editorParamString;
        this.validatorClass = src.validatorClass;
        this.editorClass = src.editorClass;
        this.editorParam = src.editorParam;
        this.complexProperty = src.complexProperty;
        this.collectionDescriptor = src.collectionDescriptor != null ? (CollectionDescriptor)src.collectionDescriptor.clone() : null;
    }

    protected void copyNonNull(PropertyDescriptor source) {
        if (this.getName() == null) {
            this.setName(source.getName());
        }
        if (this.getDisplayName() == null) {
            this.setDisplayName(source.getDisplayName());
        }
        if (this.getDescription() == null) {
            this.setDescription(source.getDescription());
        }
        if (source.required) {
            this.required = true;
        }
        if (source.readOnly) {
            this.readOnly = true;
        }
        if (source.expanded) {
            this.expanded = true;
        }
        if (this.group == null) {
            this.group = source.group;
        }
        if (this.validatorClassName == null) {
            this.validatorClassName = source.validatorClassName;
        }
        if (this.editorClassName == null) {
            this.editorClassName = source.editorClassName;
        }
        if (this.editorParamString == null) {
            this.editorParamString = source.editorParamString;
        }
        if (this.complexProperty == null) {
            this.complexProperty = source.complexProperty;
        }
        if (this.collectionDescriptor == null) {
            this.collectionDescriptor = source.collectionDescriptor;
        }
        if (this.validatorClass == null) {
            this.validatorClass = source.validatorClass;
        }
        if (this.editorClass == null) {
            this.editorClass = source.editorClass;
        }
        if (this.editorParam == null) {
            this.editorParam = source.editorParam;
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean hasRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean hasReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String getValidatorClassName() {
        return this.validatorClassName;
    }

    public void setValidatorClassName(String validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    public String getEditorClassName() {
        return this.editorClassName;
    }

    public void setEditorClassName(String editorClassName) {
        this.editorClassName = editorClassName;
    }

    public String getEditorParamString() {
        return this.editorParamString;
    }

    public void setEditorParamString(String editorParamString) {
        this.editorParamString = editorParamString;
    }

    public Class getValidatorClass() {
        return this.validatorClass;
    }

    public void setValidatorClass(Class validatorClass) {
        this.validatorClass = validatorClass;
    }

    public Class getEditorClass() {
        return this.editorClass;
    }

    public void setEditorClass(Class editorClass) {
        this.editorClass = editorClass;
    }

    public Object getEditorParam() {
        return this.editorParam;
    }

    public void setEditorParam(Object editorParam) {
        this.editorParam = editorParam;
    }

    public String getComplexPropertyType() {
        if (this.complexProperty != null) {
            return this.complexProperty.getObjectClassName();
        }
        return null;
    }

    public void setComplexPropertyType(String complexPropertyType) {
        this.complexProperty = null;
        if (complexPropertyType != null) {
            Class cls = ReflectUtil.loadClass(complexPropertyType);
            try {
                this.complexProperty = ObjectDescriptorMgr.getInstance().getDescriptor(cls, 1);
            }
            catch (XMLDriverException e) {
                e.printStackTrace();
            }
        }
    }

    public ObjectDescriptor getComplexProperty() {
        return this.complexProperty;
    }

    public void setComplexProperty(ObjectDescriptor complexProperty) {
        this.complexProperty = complexProperty;
    }

    public CollectionDescriptor getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    public void setCollectionDescriptor(CollectionDescriptor collectionDescriptor) {
        this.collectionDescriptor = collectionDescriptor;
    }
}

