/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.resource.ResourceMgr;
import org.openbp.common.resource.ResourceMgrException;
import org.springframework.core.io.Resource;

public class MultiImageIcon
extends ImageIcon
implements MultiIcon {
    private List icons;
    private List derivedIcons;
    private ImageIcon standardSizeIcon;
    private int standardSize = 16;

    public MultiImageIcon(MultiImageIcon src) {
        this.icons = src.icons;
        this.derivedIcons = src.derivedIcons;
        this.standardSizeIcon = src.standardSizeIcon;
        this.standardSize = src.standardSize;
        this.setDescription(src.getDescription());
    }

    public MultiImageIcon(ImageIcon source) {
        this.icons = new ArrayList();
        this.icons.add(source);
        this.setIconSize(source.getIconHeight());
    }

    public MultiImageIcon(String resourceName, ResourceMgr resMgr) {
        if (resMgr == null) {
            resMgr = ResourceMgr.getDefaultInstance();
        }
        this.setDescription(resourceName);
        this.icons = new ArrayList();
        int index = resourceName.lastIndexOf(".");
        String extension = resourceName.substring(index);
        resourceName = resourceName.substring(0, index);
        this.readIcons(resourceName, extension, resMgr);
        this.determineStandardSizeIcon();
    }

    private void readIcons(String resourceName, String extension, ResourceMgr resMgr) throws ResourceMgrException {
        String resourcePattern = resourceName + "*" + extension;
        Resource[] resources = null;
        try {
            resources = resMgr.findResources(resourcePattern);
        }
        catch (ResourceMgrException e) {
            throw new ResourceMgrException("No image files found matching '" + resourcePattern + "'.");
        }
        if (resources.length == 0) {
            throw new ResourceMgrException("No image files found matching '" + resourcePattern + "'.");
        }
        for (int i = 0; i < resources.length; ++i) {
            byte[] imageData = resMgr.loadByteResource(resources[i]);
            ImageIcon icon = new ImageIcon(imageData);
            this.icons.add(icon);
        }
    }

    @Override
    public int getIconSize() {
        return this.standardSize;
    }

    @Override
    public void setIconSize(int size) {
        this.standardSize = size;
        this.determineStandardSizeIcon();
    }

    @Override
    public Icon getIcon(int size) {
        ImageIcon result;
        if (size <= 0) {
            result = this.internalGet(24);
            if (result != null) {
                return result;
            }
            result = this.internalGet(32);
            if (result != null) {
                return result;
            }
            result = this.internalGet(16);
            if (result != null) {
                return result;
            }
            size = 16;
        }
        if ((result = this.internalGet(size)) == null) {
            result = this.generate(size);
            if (this.derivedIcons == null) {
                this.derivedIcons = new ArrayList();
            }
            this.derivedIcons.add(result);
        }
        return result;
    }

    @Override
    public Image getImage() {
        return this.standardSizeIcon.getImage();
    }

    private ImageIcon internalGet(int size) {
        int n = this.icons.size();
        for (int i = 0; i < n; ++i) {
            ImageIcon icon = (ImageIcon)this.icons.get(i);
            if (icon.getIconHeight() != size) continue;
            return icon;
        }
        if (this.derivedIcons != null) {
            int dn = this.derivedIcons.size();
            for (int i = 0; i < dn; ++i) {
                ImageIcon icon = (ImageIcon)this.derivedIcons.get(i);
                if (icon.getIconHeight() != size) continue;
                return icon;
            }
        }
        return null;
    }

    private ImageIcon generate(int size) {
        int maxSize = 0;
        ImageIcon largest = null;
        int n = this.icons.size();
        for (int i = 0; i < n; ++i) {
            ImageIcon icon = (ImageIcon)this.icons.get(i);
            if (icon.getIconHeight() <= maxSize) continue;
            largest = icon;
            maxSize = icon.getIconHeight();
        }
        if (largest == null) {
            return null;
        }
        Image image = largest.getImage();
        int largestWidth = largest.getIconWidth();
        int largestHeight = largest.getIconHeight();
        double ratio = (double)largestWidth / (double)largestHeight;
        int newWidth = (int)((double)size * ratio);
        image = image.getScaledInstance(size, newWidth, 16);
        return new ImageIcon(image);
    }

    private void determineStandardSizeIcon() {
        if (this.standardSize > 0) {
            this.standardSizeIcon = (ImageIcon)this.getIcon(this.standardSize);
        }
    }

    @Override
    public int getIconHeight() {
        return this.standardSizeIcon != null ? this.standardSizeIcon.getIconHeight() : 0;
    }

    @Override
    public int getIconWidth() {
        return this.standardSizeIcon != null ? this.standardSizeIcon.getIconWidth() : 0;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.standardSizeIcon != null) {
            this.standardSizeIcon.paintIcon(c, g, x, y);
        }
    }
}

