/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import org.openbp.common.string.StringUtil;
import org.openbp.common.string.shellmatcher.ShellMatcher;

public final class FileUtil {
    public static final int FILETYPE_ANY = 0;
    public static final int FILETYPE_FILE = 1;
    public static final int FILETYPE_DIR = 2;

    private FileUtil() {
    }

    public static String[] list(String dirName, String pattern, int fileType) {
        PatternFilenameFilter pff = null;
        if (pattern != null || fileType != 0) {
            pff = new PatternFilenameFilter(pattern, fileType);
        }
        File dir = new File(dirName);
        String[] fileNames = dir.list(pff);
        return fileNames;
    }

    public static void remove(File src) throws IOException {
        if (src.isFile()) {
            if (!src.delete()) {
                throw new IOException("Can't delete file '" + src.getPath() + "'");
            }
        } else {
            String[] files = src.list();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                FileUtil.remove(new File(src, files[i]));
            }
            if (!src.delete()) {
                throw new IOException("Can't delete directory '" + src.getPath() + "'");
            }
        }
    }

    public static void copy(File src, File dest) throws IOException {
        FileUtil.copy(src, dest, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest, FilenameFilter filter) throws IOException {
        block45: {
            if (!src.exists()) {
                throw new IOException("Source file not found: " + src);
            }
            if (!src.canRead()) {
                throw new IOException("Source file is unreadable: " + src);
            }
            if (src.isFile()) {
                if (!dest.exists()) {
                    File parentdir = FileUtil.getParent(dest, false);
                    if (parentdir != null && !parentdir.exists()) {
                        parentdir.mkdirs();
                    }
                } else if (dest.isDirectory()) {
                    String srcStr = src.toString();
                    int iSep = srcStr.lastIndexOf(47);
                    String baseName = iSep >= 0 ? srcStr.substring(iSep + 1) : srcStr;
                    dest = new File(dest + "/" + baseName);
                }
            } else if (src.isDirectory()) {
                if (dest.isFile()) {
                    throw new IOException("Cannot copy directory " + src + " to file " + dest);
                }
                if (!dest.exists()) {
                    dest.mkdirs();
                }
            }
            if (src.isFile()) {
                FileInputStream source = null;
                FileOutputStream destination = null;
                try {
                    source = new FileInputStream(src);
                    destination = new FileOutputStream(dest);
                    byte[] buffer = new byte[1024];
                    while (true) {
                        int bytesRead;
                        if ((bytesRead = source.read(buffer)) == -1) {
                            break block45;
                        }
                        destination.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (IOException e) {}
                    }
                    if (destination != null) {
                        try {
                            destination.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            if (src.isDirectory()) {
                String[] files = src.list(filter);
                block23: for (int i = 0; i < files.length; ++i) {
                    String member = files[i];
                    String srcMember = StringUtil.buildPath(src.getPath(), member);
                    String destMember = StringUtil.buildPath(dest.getPath(), member);
                    if (new File(srcMember).isDirectory()) {
                        FileUtil.copy(new File(srcMember), new File(destMember), filter);
                        continue;
                    }
                    FileInputStream source = null;
                    FileOutputStream destination = null;
                    try {
                        source = new FileInputStream(srcMember);
                        destination = new FileOutputStream(destMember);
                        byte[] buffer = new byte[1024];
                        while (true) {
                            int bytesRead;
                            if ((bytesRead = source.read(buffer)) == -1) {
                                continue block23;
                            }
                            destination.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (IOException e) {}
                        }
                        if (destination != null) {
                            try {
                                destination.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
        }
    }

    public static File getParent(File f, boolean returnCurrent) {
        try {
            String dirname = f.getParent();
            if (dirname != null) {
                return new File(dirname);
            }
            if (f.isAbsolute()) {
                return new File("/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnCurrent ? new File(System.getProperty("user.dir")) : null;
    }

    static class PatternFilenameFilter
    implements FilenameFilter {
        private ShellMatcher sm = null;
        private int fileType;

        public PatternFilenameFilter(String pattern, int fileType) {
            if (pattern != null) {
                this.sm = new ShellMatcher(pattern);
                this.sm.setIgnoreCase(true);
            }
            this.fileType = fileType;
        }

        @Override
        public boolean accept(File dir, String name) {
            File f;
            if (this.sm != null && !this.sm.match(name)) {
                return false;
            }
            return this.fileType == 0 || !((f = new File(StringUtil.buildPath(dir.getPath(), name))).isDirectory() ? this.fileType == 1 : this.fileType == 2);
        }
    }
}

