/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.listener;

import java.util.EventListener;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openbp.common.util.WeakArrayList;
import org.openbp.common.util.iterator.EmptyIterator;

public class ListenerSupport {
    private WeakArrayList list;

    public void addListener(Class listenerClass, EventListener listener) {
        if (this.list == null) {
            this.list = new WeakArrayList();
        } else {
            this.trim();
            if (this.containsListener(listenerClass, listener)) {
                return;
            }
        }
        this.list.addHardReference(listenerClass);
        this.list.addHardReference(listener);
    }

    public void addWeakListener(Class listenerClass, EventListener listener) {
        if (this.list == null) {
            this.list = new WeakArrayList();
        } else {
            this.trim();
            if (this.containsListener(listenerClass, listener)) {
                return;
            }
        }
        this.list.addHardReference(listenerClass);
        this.list.add(listener);
    }

    public void removeListener(Class listenerClass, EventListener listener) {
        if (this.list == null) {
            return;
        }
        boolean doTrim = false;
        int n = this.list.size();
        for (int i = 0; i < n; i += 2) {
            Class cls;
            if (listenerClass != null && (cls = (Class)this.list.get(i)) != listenerClass) continue;
            Object o = this.list.get(i + 1);
            if (o != null) {
                if (listener != null && listener != o) continue;
                this.list.set(i, (Object)null);
                this.list.set(i + 1, (Object)null);
                doTrim = true;
                continue;
            }
            this.list.set(i, (Object)null);
            doTrim = true;
        }
        if (doTrim) {
            this.list.trim();
        }
    }

    public void removeAllListeners(Class listenerClass) {
        this.removeListener(listenerClass, null);
    }

    public void trim() {
        if (this.list != null) {
            boolean doTrim = false;
            int n = this.list.size();
            for (int i = 0; i < n; i += 2) {
                Object o = this.list.get(i + 1);
                if (o != null) continue;
                this.list.set(i, (Object)null);
                this.list.set(i + 1, (Object)null);
                doTrim = true;
            }
            if (doTrim) {
                this.list.trim();
            }
        }
    }

    public boolean containsListeners(Class listenerClass) {
        return this.containsListener(listenerClass, null);
    }

    public boolean containsListener(Class listenerClass, EventListener listener) {
        if (this.list != null) {
            int n = this.list.size();
            for (int i = 0; i < n; i += 2) {
                Object o;
                Class cls;
                if (listenerClass != null && (cls = (Class)this.list.get(i)) != listenerClass || (o = this.list.get(i + 1)) == null) continue;
                if (listener != null) {
                    if (listener != o) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public int getListenerCount(Class listenerClass) {
        int count = 0;
        if (this.list != null) {
            int n = this.list.size();
            for (int i = 0; i < n; i += 2) {
                Class cls = (Class)this.list.get(i);
                if (cls != listenerClass) continue;
                ++count;
            }
        }
        return count;
    }

    public Iterator getListenerIterator(Class listenerClass) {
        if (this.getListenerCount(listenerClass) == 0) {
            return EmptyIterator.getInstance();
        }
        return new ListenerIterator(listenerClass);
    }

    public class ListenerIterator
    implements Iterator {
        private Class listenerClass;
        private int index;
        private boolean doTrim;

        public ListenerIterator(Class listenerClass) {
            this.listenerClass = listenerClass;
        }

        @Override
        public boolean hasNext() {
            int n = ListenerSupport.this.list.size();
            while (this.index < n) {
                Object o = ListenerSupport.this.list.get(this.index + 1);
                if (o == null) {
                    this.doTrim = true;
                } else {
                    Class cls = (Class)ListenerSupport.this.list.get(this.index);
                    if (cls == this.listenerClass) {
                        return true;
                    }
                }
                this.index += 2;
            }
            if (this.doTrim) {
                ListenerSupport.this.trim();
            }
            return false;
        }

        public Object next() {
            if (this.index < ListenerSupport.this.list.size()) {
                Object o = ListenerSupport.this.list.get(this.index + 1);
                this.index += 2;
                return o;
            }
            throw new NoSuchElementException("Iterator reached end of ListenerSupport list");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Remove operation not supported by ListenerSupport iterator");
        }
    }
}

