/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.markup;

public final class XMLEscapeHelper {
    private XMLEscapeHelper() {
    }

    public static String encodeXMLContent(String str) {
        if (str == null) {
            return "";
        }
        int len = str.length();
        if (len == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len > 16 ? len * 110 / 100 : 16);
        block7: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        char integer = c;
                        sb.append("&#" + integer + ";");
                        continue block7;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String encodeXMLString(String str) {
        if (str == null) {
            return "";
        }
        int len = str.length();
        if (len == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len > 16 ? len * 110 / 100 : 16);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c > '~') {
                char integer = c;
                sb.append("&#" + integer + ";");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

