/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.markup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openbp.common.CollectionUtil;
import org.openbp.common.markup.XMLEscapeHelper;
import org.openbp.common.string.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private XMLUtil() {
    }

    public static Document parseDocument(InputSource is) throws IOException, SAXException {
        if (is == null) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("XML parser configuration problem: " + e.getMessage(), e);
        }
    }

    public static Document parseDocument(String fileName) throws IOException, SAXException {
        if (fileName == null) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(fileName);
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("XML parser configuration problem: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDocument(String fileName, Map substitute) throws IOException, SAXException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            String fileString = XMLUtil.readFile(in);
            fileString = XMLEscapeHelper.encodeXMLString(fileString);
            if (substitute != null) {
                fileString = StringUtil.substitute(fileString, substitute);
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(fileString.getBytes());
            Document document = XMLUtil.parseDocument(new InputSource(bin));
            return document;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void serialize(Document document, String fileName) throws IOException {
        if (document == null) {
            return;
        }
        Exception targetException = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            FileOutputStream os = new FileOutputStream(new File(fileName));
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            targetException = e;
        }
        catch (FileNotFoundException e) {
            targetException = e;
        }
        catch (TransformerException e) {
            targetException = e;
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IOException("Error serializing XML data to file '" + fileName + "':" + e.toString());
        }
        if (targetException != null) {
            throw new IOException("Error serializing XML data to file '" + fileName + "': " + targetException.getMessage());
        }
    }

    public static String serialize(Document document) throws IOException {
        if (document != null) {
            TransformerException targetException = null;
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(document);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
                return os.toString();
            }
            catch (TransformerConfigurationException e) {
                targetException = e;
            }
            catch (TransformerException e) {
                targetException = e;
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new IOException("Error serializing XML data:" + e.toString());
            }
            if (targetException != null) {
                throw new IOException("Error serializing XML data: " + targetException.getMessage());
            }
        }
        return null;
    }

    public static Node getChildNode(Node parent, String childName) {
        return XMLUtil.getChildElement(parent, childName);
    }

    public static Element getChildElement(Node parent, String childName) {
        return (Element)XMLUtil.getChildNode(parent, childName, (short)1);
    }

    public static Node getChildNode(Node parent, String childName, short nodeType) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != nodeType || childName != null && !childName.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    public static Element[] getChildElements(Node parent, String childName) {
        return XMLUtil.getChildElements(parent, new String[]{childName});
    }

    public static Element[] getChildElements(Node parent, String[] childNames) {
        ArrayList childNameList = new ArrayList();
        CollectionUtil.addAll(childNameList, childNames);
        ArrayList<Node> elements = new ArrayList<Node>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !childNameList.contains(child.getNodeName())) continue;
            elements.add(child);
        }
        return elements.toArray(new Element[elements.size()]);
    }

    public static String getChildNodeValue(Node parent, String childName) {
        String value = null;
        Node child = XMLUtil.getChildNode(parent, childName);
        if (child != null) {
            value = XMLUtil.getNodeValue(child);
        }
        return value;
    }

    public static String getChildNodeValue(Node parent, String childName, short nodeType) {
        String value = null;
        Node child = XMLUtil.getChildNode(parent, childName, nodeType);
        if (child != null) {
            value = XMLUtil.getNodeValue(child);
        }
        return value;
    }

    public static String getNodeValue(Node node) {
        String value = null;
        if (node != null) {
            Node child;
            value = node.getNodeValue();
            if (value == null && (child = node.getFirstChild()) != null) {
                value = child.getNodeValue();
            }
            if (value != null && (value = value.trim()).length() == 0) {
                value = null;
            }
        }
        return value;
    }

    public static boolean compareStringNode(Node node, String tag) {
        if (tag.indexOf(node.getNodeName()) == -1) {
            return false;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (tag.indexOf(attributes.item(i).getNodeName()) == -1) {
                    return false;
                }
                if (tag.indexOf(attributes.item(i).getNodeValue()) != -1) continue;
                return false;
            }
        }
        return true;
    }

    private static String readFile(InputStream in) throws IOException {
        byte[] data = new byte[in.available()];
        in.read(data);
        return new String(data);
    }
}

