/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.openbp.common.util.ToStringHelper;

public class ByteArrayURLConnection
extends URLConnection {
    byte[] bytes;

    public ByteArrayURLConnection(URL url, byte[] bytes) {
        super(url);
        this.bytes = bytes;
    }

    @Override
    public void connect() {
    }

    @Override
    public int getContentLength() {
        return this.bytes.length;
    }

    @Override
    public String getContentType() {
        String type = null;
        try {
            type = ByteArrayURLConnection.guessContentTypeFromStream(new ByteArrayInputStream(this.bytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return type;
    }

    @Override
    public Object getContent() throws IOException {
        return this.bytes;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("bytearray URLs cannot be written to");
    }

    @Override
    public String toString() {
        return ToStringHelper.toString((Object)this, "uRL");
    }
}

