/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.property;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.openbp.common.property.PropertyException;
import org.openbp.common.string.StringUtil;

public final class PropertyAccessUtil {
    private PropertyAccessUtil() {
    }

    public static Object getProperty(Object base, String property) throws PropertyException {
        property = StringUtil.decapitalize(property);
        if (base == null) {
            throw new PropertyException("Cannot access property '" + property + "' with null base object.");
        }
        Object ret = null;
        Exception ex = null;
        try {
            ret = PropertyUtils.getProperty((Object)base, (String)property);
        }
        catch (NestedNullException e) {
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        if (ex != null) {
            throw new PropertyException("Error accessing property '" + property + "' of object of type '" + base.getClass().getName() + "'.", ex);
        }
        return ret;
    }

    public static void setProperty(Object base, String property, Object value) throws PropertyException {
        property = StringUtil.decapitalize(property);
        if (base == null) {
            throw new PropertyException("Cannot access property '" + property + "' with null base object.");
        }
        Throwable ex = null;
        try {
            PropertyUtils.setProperty((Object)base, (String)property, (Object)value);
        }
        catch (NestedNullException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        if (ex != null) {
            String valueType = value != null ? value.getClass().getName() : null;
            throw new PropertyException("Error setting property '" + property + "' of object of type '" + base.getClass().getName() + "' to value of type '" + valueType + "'.", (Exception)ex);
        }
    }
}

