/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.rc;

import java.util.Locale;
import org.openbp.common.MsgFormat;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;

public final class ResourceCollectionUtil {
    public static final String RESOURCE_KEY_DESCRIPTION = "description";
    public static final String RESOURCE_KEY_DISPLAYNAME = "displayname";

    private ResourceCollectionUtil() {
    }

    public static String formatMsg(ResourceCollection res, String key, Object[] args) {
        String msg = res.getRequiredString(key);
        msg = msg != null ? MsgFormat.format(msg, args) : MsgFormat.format("Cannot access string resource item $0 in resource $1.", key, res.getErrorName());
        return msg;
    }

    public static String formatMsg(String containerName, String resourceName, String key, Object[] args) {
        ResourceCollection res = ResourceCollectionMgr.getDefaultInstance().getResource(containerName, resourceName);
        String msg = res != null ? ResourceCollectionUtil.formatMsg(res, key, args) : MsgFormat.format("Cannot access resource $0 in container $1.", resourceName, containerName);
        return msg;
    }

    public static String formatMsg(String containerName, String resourceName, Locale locale, String key, Object[] args) {
        ResourceCollection res = ResourceCollectionMgr.getDefaultInstance().getResource(containerName, resourceName, locale);
        String msg = res != null ? ResourceCollectionUtil.formatMsg(res, key, args) : MsgFormat.format("Cannot access resource $0 in container $1.", resourceName, containerName);
        return msg;
    }

    public static String formatMsg(ResourceCollection res, String key, Object arg1) {
        return ResourceCollectionUtil.formatMsg(res, key, new Object[]{arg1});
    }

    public static String formatMsg(ResourceCollection res, String key, Object arg1, Object arg2) {
        return ResourceCollectionUtil.formatMsg(res, key, new Object[]{arg1, arg2});
    }

    public static String formatMsg(ResourceCollection res, String key, Object arg1, Object arg2, Object arg3) {
        return ResourceCollectionUtil.formatMsg(res, key, new Object[]{arg1, arg2, arg3});
    }

    public static String formatMsg(String containerName, String resourceName, String key, Object arg1) {
        return ResourceCollectionUtil.formatMsg(containerName, resourceName, key, new Object[]{arg1});
    }

    public static String formatMsg(String containerName, String resourceName, String key, Object arg1, Object arg2) {
        return ResourceCollectionUtil.formatMsg(containerName, resourceName, key, new Object[]{arg1, arg2});
    }

    public static String formatMsg(String containerName, String resourceName, String key, Object arg1, Object arg2, Object arg3) {
        return ResourceCollectionUtil.formatMsg(containerName, resourceName, key, new Object[]{arg1, arg2, arg3});
    }

    public static String formatMsg(String containerName, String resourceName, Locale locale, String key, Object arg1) {
        return ResourceCollectionUtil.formatMsg(containerName, resourceName, locale, key, new Object[]{arg1});
    }

    public static String formatMsg(String containerName, String resourceName, Locale locale, String key, Object arg1, Object arg2) {
        return ResourceCollectionUtil.formatMsg(containerName, resourceName, locale, key, new Object[]{arg1, arg2});
    }

    public static String formatMsg(String containerName, String resourceName, Locale locale, String key, Object arg1, Object arg2, Object arg3) {
        return ResourceCollectionUtil.formatMsg(containerName, resourceName, locale, key, new Object[]{arg1, arg2, arg3});
    }

    public static int getOptionalInt(ResourceCollection res, String key, int dflt) {
        String value;
        if (res != null && (value = res.getOptionalString(key)) != null) {
            return new Integer(value);
        }
        return dflt;
    }

    public static char getOptionalChar(ResourceCollection res, String key, char dflt) {
        String value;
        if (res != null && (value = res.getOptionalString(key)) != null) {
            if (value.length() == 1) {
                return value.charAt(0);
            }
            return (char)new Integer(value).intValue();
        }
        return dflt;
    }

    public static void loadDescriptionObjectFromResource(DescriptionObject o, ResourceCollection res, String prefix) {
        String key = prefix != null ? prefix + "." + RESOURCE_KEY_DESCRIPTION : RESOURCE_KEY_DESCRIPTION;
        o.setDescription(res.getOptionalString(key));
    }

    public static void loadDisplayObjectFromResource(DisplayObject o, ResourceCollection res, String prefix) {
        ResourceCollectionUtil.loadDescriptionObjectFromResource(o, res, prefix);
        String key = prefix != null ? prefix + "." + RESOURCE_KEY_DISPLAYNAME : RESOURCE_KEY_DISPLAYNAME;
        o.setDisplayName(res.getOptionalString(key));
    }
}

