/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.rc.image;

import javax.swing.ImageIcon;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.markup.XMLUtil;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceItem;
import org.openbp.common.resource.ResourceMgrException;
import org.w3c.dom.Element;

public abstract class AbstractJavaImage
extends ResourceItem {
    protected static final String TAG_IMAGE_PATH = "path";
    private String path;

    @Override
    public void initializeFromDOM(ResourceCollection res, Element sourceElement, String group) {
        super.initializeFromDOM(res, sourceElement, group);
        this.path = XMLUtil.getChildNodeValue(sourceElement, TAG_IMAGE_PATH);
        if (this.path == null) {
            LogUtil.error(this.getClass(), "Resource $0: Missing or invalid tag $1.", this.getErrorName(), TAG_IMAGE_PATH);
            return;
        }
        this.path = res.getResourceCollectionMgr().performVariableReplacement(this.path);
        this.path = this.path.replace('\\', '/');
        if (!this.checkFileExtension(this.path.substring(this.path.lastIndexOf(46) + 1))) {
            LogUtil.error(this.getClass(), "Resource $0: Unsupported image file name extension.", this.getErrorName());
            return;
        }
    }

    @Override
    protected Object loadResourceObject() {
        if (this.path == null) {
            return null;
        }
        byte[] imageData = null;
        try {
            imageData = this.resourceCollection.readResourceItem(this.path);
        }
        catch (ResourceMgrException e) {
            LogUtil.error(this.getClass(), "Resource $0: Image file $1 does not exist.", this.getErrorName(), this.resourceCollection.getResourceItemPath(this.path));
            return null;
        }
        if (imageData == null) {
            LogUtil.error(this.getClass(), "Resource $0: Image file $1 is empty.", this.getErrorName(), this.resourceCollection.getResourceItemPath(this.path));
            return null;
        }
        ImageIcon image = new ImageIcon(imageData);
        image.setDescription(this.resourceCollection.getResourceItemPath(this.path));
        return image;
    }

    protected boolean checkFileExtension(String extension) {
        String[] extensions = this.getFileExtensions();
        if (extension == null) {
            return false;
        }
        extension = extension.toLowerCase();
        for (int i = 0; i < extensions.length; ++i) {
            if (!extension.equals(extensions[i])) continue;
            return true;
        }
        return false;
    }

    protected abstract String[] getFileExtensions();
}

