/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.registry.MappingRegistryExtender;
import org.openbp.common.util.iterator.EmptyIterator;

public class MappingRegistry {
    private Map registeredObjects = new HashMap();
    private List extenderList = new ArrayList();

    public Object lookup(String key) {
        Object o;
        block1: {
            MappingRegistryExtender extender;
            o = this.registeredObjects.get(key);
            if (o != null) break block1;
            Iterator it = this.getExtenders();
            while (it.hasNext() && (o = (extender = (MappingRegistryExtender)it.next()).lookup(key)) == null) {
            }
        }
        return o;
    }

    public void register(String key, Object object) {
        this.registeredObjects.put(key, object);
    }

    public Object lookup(Class cls) {
        return this.lookup(cls, false);
    }

    public Object lookupMandatory(Class cls) {
        return this.lookup(cls, true);
    }

    private Object lookup(Class cls, boolean mandatory) {
        Object o = this.registeredObjects.get(cls.getName());
        if (o == null) {
            Iterator it = this.getExtenders();
            while (it.hasNext()) {
                MappingRegistryExtender extender = (MappingRegistryExtender)it.next();
                o = extender.lookup(cls);
                if (o == null) continue;
                return o;
            }
            if (mandatory) {
                String msg = LogUtil.error(MappingRegistry.class, "No mapping of type $0 could be found in the mapping registry.", new Object[]{cls.getName()});
                throw new RuntimeException(msg);
            }
        }
        return o;
    }

    public void register(Object object) {
        this.registerByClass(object.getClass(), object);
    }

    public void registerByClass(Class cls, Object object) {
        if (this.lookup(cls) != null) {
            return;
        }
        this.register(cls.getName(), object);
        Class superClass = cls.getSuperclass();
        if (superClass != null && !superClass.getName().equals("java.lang.Object")) {
            this.registerByClass(superClass, object);
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.registerByClass(interfaces[i], object);
        }
    }

    public void unregister(Object object) {
        Iterator it = this.registeredObjects.values().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o != object) continue;
            it.remove();
        }
    }

    public void unregisterAll() {
        this.registeredObjects.clear();
    }

    public Iterator getExtenders() {
        if (this.extenderList == null) {
            return EmptyIterator.getInstance();
        }
        return this.extenderList.iterator();
    }

    public void addExtender(MappingRegistryExtender extender) {
        if (this.extenderList == null) {
            this.extenderList = new ArrayList();
        }
        this.extenderList.add(extender);
    }
}

