/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.resource;

import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.resource.ResourceProvider;
import org.openbp.common.string.StringUtil;
import org.openbp.common.util.ToStringHelper;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class FileResourceProvider
extends ResourceProvider {
    private String resourceDir;

    public FileResourceProvider(int priority, ResourceLoader loader, String resourceDir) {
        super(priority, loader);
        this.setResourceDir(resourceDir);
    }

    public String toString() {
        return ToStringHelper.toString(this, "resourceDir", "priority");
    }

    @Override
    public Resource getResource(String resourceLocation) throws ResourceMgrException {
        String resourceName = resourceLocation;
        if (this.hasPrefix(resourceName = StringUtil.normalizePathName(resourceName))) {
            int index = resourceName.indexOf(58);
            resourceName = resourceName.substring(index + 1);
        }
        if (this.resourceDir != null && !resourceName.startsWith(this.resourceDir)) {
            resourceName = StringUtil.buildPath(this.resourceDir, resourceName);
        }
        resourceName = "file:" + resourceName;
        return this.getResourceLoader().getResource(resourceName);
    }

    @Override
    public String getPrefix() {
        return "file:";
    }

    public String getResourceDir() {
        return this.resourceDir;
    }

    public void setResourceDir(String resourceDir) {
        this.resourceDir = StringUtil.normalizeDir(resourceDir);
    }
}

