/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.resource;

import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.resource.ResourceProvider;
import org.openbp.common.util.ToStringHelper;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class HttpResourceProvider
extends ResourceProvider {
    private String protocol;
    private String host;
    private String port;

    protected HttpResourceProvider(int priority, ResourceLoader resourceLoader, String protocol, String host, String port) {
        super(priority, resourceLoader);
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public String toString() {
        return ToStringHelper.toString(this, "urlPrefix", "priority");
    }

    public String getUrlPrefix() {
        String host;
        String port = this.getPort();
        String protocol = this.getProtocol().toLowerCase();
        if (protocol == null) {
            protocol = "http:";
        }
        if ((host = this.getHost()) == null) {
            host = "localhost";
        }
        StringBuffer sb = new StringBuffer(protocol);
        sb.append("//");
        sb.append(host);
        if (port != null) {
            if (!port.startsWith(":")) {
                sb.append(":");
            }
            sb.append(port);
        }
        return sb.toString();
    }

    @Override
    public Resource getResource(String resourceLocation) throws ResourceMgrException {
        String resourceName = resourceLocation;
        if (!this.hasPrefix(resourceName)) {
            resourceName = this.applyPrefix(resourceName);
        }
        return this.getResourceLoader().getResource(resourceName);
    }

    @Override
    public String applyPrefix(String resourceLocation) {
        String resourceName = resourceLocation;
        if (!resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        return this.getUrlPrefix() + resourceName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

