/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.openbp.common.application.Application;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.resource.ClasspathResourceProvider;
import org.openbp.common.resource.FileResourceProvider;
import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.resource.ResourceResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ResourceMgr {
    public static final int USERHOMEDIR_RESOURCE_PROVIDER_PRIO = 25;
    public static final int ROOTDIR_RESOURCE_PROVIDER_PRIO = 50;
    public static final int CLASSPATH_RESOURCE_PROVIDER_PRIO = 100;
    private ResourceLoader resourceLoader;
    private ResourceResolver resourceResolver;
    private static ResourceMgr singletonInstance;

    public ResourceMgr() {
        this((ResourceLoader)new PathMatchingResourcePatternResolver());
    }

    public ResourceMgr(ResourceLoader resourceLoader) {
        String userHomeDir;
        new URLConnection(null){

            @Override
            public void connect() throws IOException {
            }
        }.setDefaultUseCaches(false);
        this.resourceLoader = resourceLoader;
        this.resourceResolver = new ResourceResolver();
        this.resourceResolver.addProvider(new ClasspathResourceProvider(100, resourceLoader));
        if (Application.getRootDir() != null) {
            this.resourceResolver.addProvider(new FileResourceProvider(50, resourceLoader, Application.getRootDir()));
        }
        if ((userHomeDir = System.getenv("HOME")) != null) {
            this.resourceResolver.addProvider(new FileResourceProvider(25, resourceLoader, userHomeDir));
        }
    }

    public static synchronized ResourceMgr getDefaultInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ResourceMgr();
        }
        return singletonInstance;
    }

    public Resource getResource(String resourceLocation) {
        if (this.getResourceLoader() == null) {
            throw new ResourceMgrException("Resource loader not set.");
        }
        Resource res = this.getResourceResolver().getResource(resourceLocation);
        return res;
    }

    public InputStream openResource(String resourceLocation) throws ResourceMgrException {
        Resource res = this.getResource(resourceLocation);
        InputStream is = null;
        try {
            is = res.getInputStream();
        }
        catch (IOException e) {
            String msg = LogUtil.error(this.getClass(), "Could not find resource  $0.", new Object[]{res.getDescription()});
            throw new ResourceMgrException(msg, e);
        }
        return is;
    }

    public byte[] loadByteResource(String resourceLocation) throws ResourceMgrException {
        Resource res = this.getResource(resourceLocation);
        return this.loadByteResource(res);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] loadByteResource(Resource res) throws ResourceMgrException {
        InputStream is = null;
        try {
            is = res.getInputStream();
        }
        catch (IOException e) {
            String msg = LogUtil.error(this.getClass(), "Could not find resource $0.", new Object[]{res.getDescription()});
            throw new ResourceMgrException(msg, e);
        }
        byte[] bytes = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = is.read(buffer)) != -1) {
                os.write(buffer, 0, n);
            }
            bytes = os.toByteArray();
        }
        catch (IOException e) {
            try {
                String msg = LogUtil.error(this.getClass(), "Could not entirely read resource $0.", new Object[]{res.getDescription()});
                throw new ResourceMgrException(msg, e);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    String msg = LogUtil.error(this.getClass(), "Could not close resource $0.", new Object[]{res.getDescription()});
                    throw new ResourceMgrException(msg, e2);
                }
            }
        }
        try {
            is.close();
            return bytes;
        }
        catch (IOException e) {
            String msg = LogUtil.error(this.getClass(), "Could not close resource $0.", new Object[]{res.getDescription()});
            throw new ResourceMgrException(msg, e);
        }
    }

    public Resource[] findResources(String resourceLocation) throws ResourceMgrException {
        PathMatchingResourcePatternResolver matcher = new PathMatchingResourcePatternResolver(this.resourceLoader);
        int i = resourceLocation.indexOf(58);
        if (i < 0) {
            resourceLocation = "classpath*:" + resourceLocation;
        }
        try {
            Resource[] ret = matcher.getResources(resourceLocation);
            return ret;
        }
        catch (Exception e) {
            String msg = "Error during resource search for resource '" + resourceLocation + "'.";
            throw new ResourceMgrException(msg, e);
        }
    }

    public URL getURL(String resourceLocation) {
        Resource res = this.getResource(resourceLocation);
        URL url = null;
        try {
            url = res.getURL();
        }
        catch (IOException e) {
            String msg = LogUtil.error(this.getClass(), "Error during resource search for resource $0.", new Object[]{resourceLocation});
            throw new ResourceMgrException(msg, e);
        }
        return url;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }
}

