/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.resource;

import org.openbp.common.resource.ResourceMgrException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public abstract class ResourceProvider {
    public static final String PROTOCOL_PREFIX_SEPARATOR = ":";
    protected ResourceLoader resourceLoader;
    private int priority;

    protected ResourceProvider(int priority, ResourceLoader resourceLoader) {
        this.priority = priority;
        this.resourceLoader = resourceLoader;
    }

    public abstract Resource getResource(String var1) throws ResourceMgrException;

    public String getPrefix() {
        return "";
    }

    public boolean hasPrefix(String resourceLocation) {
        return resourceLocation.indexOf(PROTOCOL_PREFIX_SEPARATOR) > 0 && ((resourceLocation = resourceLocation.toLowerCase()).startsWith("file:") || resourceLocation.startsWith("classpath:") || resourceLocation.startsWith("http:"));
    }

    public String applyPrefix(String resourceLocation) {
        if (this.hasPrefix(resourceLocation)) {
            return resourceLocation;
        }
        return this.getPrefix() + resourceLocation;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

