/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.resource;

import java.util.Vector;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.resource.ResourceProvider;
import org.springframework.core.io.Resource;

public class ResourceResolver {
    Vector providerList = new Vector();

    public void addProvider(ResourceProvider provider) {
        LogUtil.info(this.getClass(), "Adding resource provider {0}.", provider);
        if (this.providerList.isEmpty()) {
            this.providerList.add(provider);
        } else {
            for (int i = 0; i < this.providerList.size(); ++i) {
                ResourceProvider p = (ResourceProvider)this.providerList.get(i);
                if (p.getPriority() <= provider.getPriority()) continue;
                this.providerList.add(i, provider);
                return;
            }
            this.providerList.add(provider);
        }
    }

    Resource getResource(String resourceLocation) {
        Resource resource = null;
        for (int i = 0; i < this.providerList.size(); ++i) {
            ResourceProvider provider = (ResourceProvider)this.providerList.get(i);
            resource = provider.getResource(resourceLocation);
            if (resource == null || !resource.exists()) continue;
            return resource;
        }
        String msg = "The resource '" + resourceLocation + "' could not be found by any resource provider.";
        throw new ResourceMgrException(msg);
    }

    protected String getProviderInfoString() {
        String providers = "";
        String separator = ";";
        for (int i = 0; i < this.providerList.size(); ++i) {
            if (i > 0) {
                providers = providers + separator;
            }
            ResourceProvider provider = (ResourceProvider)this.providerList.get(i);
            providers = providers + provider.toString();
        }
        return providers;
    }

    public void clearProviderList() {
        this.providerList.clear();
    }
}

