/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.setting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.openbp.common.CommonUtil;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.resource.ResourceMgr;
import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.setting.SettingProvider;
import org.openbp.common.util.ToStringHelper;
import org.springframework.core.io.Resource;

public class PropertyFileProvider
implements SettingProvider {
    private String propertyResourceName;
    private String fileHeader;
    private boolean readonly;
    private boolean mandatory;
    private boolean saveExistingPropertiesOnly;
    private Properties properties = new Properties();
    private boolean dirty;

    public void clear() {
        this.properties.clear();
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, new String[]{"propertyResourceName", "propertyResourceUrl"});
    }

    public String getPropertyResourceName() {
        return this.propertyResourceName;
    }

    public void setPropertyResourceName(String propertyResourceName) {
        this.propertyResourceName = propertyResourceName;
    }

    public URL getPropertyResourceUrl() {
        URL url = null;
        try {
            if (this.propertyResourceName != null) {
                url = ResourceMgr.getDefaultInstance().getURL(this.propertyResourceName);
            }
        }
        catch (ResourceMgrException resourceMgrException) {
            // empty catch block
        }
        return url;
    }

    public String getFileHeader() {
        return this.fileHeader;
    }

    public void setFileHeader(String fileHeader) {
        this.fileHeader = fileHeader;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isSaveExistingPropertiesOnly() {
        return this.saveExistingPropertiesOnly;
    }

    public void setSaveExistingPropertiesOnly(boolean saveExistingPropertiesOnly) {
        this.saveExistingPropertiesOnly = saveExistingPropertiesOnly;
    }

    @Override
    public Object getSetting(String name) {
        return this.properties.getProperty(name, null);
    }

    @Override
    public boolean setSetting(String name, Object value) {
        Object oldValue = this.getSetting(name);
        if ((this.saveExistingPropertiesOnly || this.readonly) && oldValue == null) {
            return false;
        }
        if (!CommonUtil.equalsNull(value, oldValue)) {
            if (value == null) {
                this.properties.remove(name);
            } else {
                this.properties.setProperty(name, value.toString());
            }
            this.dirty = true;
        }
        return true;
    }

    @Override
    public boolean loadSettings() {
        this.dirty = false;
        if (this.propertyResourceName == null) {
            return true;
        }
        InputStream is = null;
        try {
            is = ResourceMgr.getDefaultInstance().openResource(this.propertyResourceName);
            this.properties.load(is);
        }
        catch (ResourceMgrException e) {
            if (this.mandatory) {
                throw new RuntimeException("Property resource '" + this.propertyResourceName + "' not found.", e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading property resource '" + this.propertyResourceName + "'.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveSettings() {
        if (this.readonly || !this.dirty) {
            return true;
        }
        if (this.propertyResourceName == null) {
            LogUtil.error(this.getClass(), "Missing property file name for property file provider");
            return false;
        }
        Resource res = ResourceMgr.getDefaultInstance().getResource(this.propertyResourceName);
        FileOutputStream out = null;
        try {
            File file = res.getFile();
            out = new FileOutputStream(file);
            this.properties.store(out, this.fileHeader);
            out.flush();
        }
        catch (IOException e) {
            LogUtil.error(this.getClass(), "Error writing property file $0.", this.propertyResourceName, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        this.dirty = false;
        return true;
    }
}

