/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.setting;

import java.util.Enumeration;
import java.util.Properties;
import org.openbp.common.MsgFormat;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.setting.SettingProvider;
import org.openbp.common.setting.SettingResolver;

public final class SettingUtil {
    public static final char PROVIDER_SEPARATOR = ':';
    private static SettingResolver standardResolver;

    private SettingUtil() {
    }

    public static SettingResolver getStandardResolver() {
        if (standardResolver == null) {
            standardResolver = new SettingResolver();
        }
        return standardResolver;
    }

    public static void setStandardResolver(SettingResolver standardResolverArg) {
        standardResolver = standardResolverArg;
    }

    public static String getStringSetting(String name, String dflt, SettingResolver resolver) {
        Object value = null;
        if (resolver != null) {
            value = resolver.getSetting(name, dflt);
        }
        if (value == null) {
            return dflt;
        }
        return value.toString();
    }

    public static boolean getBooleanSetting(String name, boolean dflt, SettingResolver resolver) {
        Object value = resolver.getSetting(name, null);
        if (value == null) {
            return dflt;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return dflt;
    }

    public static SettingProvider setStringSetting(String name, String value, SettingResolver resolver) {
        return resolver.setSetting(name, value);
    }

    public static int getIntSetting(String name, int dflt, SettingResolver resolver) {
        Object value = resolver.getSetting(name, null);
        if (value == null) {
            return dflt;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return dflt;
    }

    public static SettingProvider setBooleanSetting(String name, boolean value, SettingResolver resolver) {
        return resolver.setSetting(name, new Boolean(value));
    }

    public static SettingProvider setIntSetting(String name, int value, SettingResolver resolver) {
        return resolver.setSetting(name, new Integer(value));
    }

    public static String expandVariables(String s, boolean mandatory, SettingResolver resolver) {
        if (s == null) {
            return null;
        }
        int l = s.length();
        if (l == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c == '$' && i + 1 < l && s.charAt(i + 1) == '{') {
                StringBuffer valuePrefix = new StringBuffer();
                StringBuffer valueSuffix = new StringBuffer();
                StringBuffer defaultPrefix = new StringBuffer();
                StringBuffer defaultSuffix = new StringBuffer();
                int end = s.indexOf(125, i += 2);
                if (end < 0) break;
                String text = s.substring(i, end);
                String key = null;
                int iKeyStart = SettingUtil.getQMarkExpr(text, 0, valuePrefix, defaultPrefix);
                int iQmark = text.indexOf("?", iKeyStart);
                if (iQmark >= 0) {
                    key = text.substring(iKeyStart, iQmark);
                    SettingUtil.getQMarkExpr(text, iQmark, valueSuffix, defaultSuffix);
                } else {
                    key = text.substring(iKeyStart);
                }
                String value = SettingUtil.getStringSetting(key, null, resolver);
                if (value == null && mandatory) {
                    String msg = MsgFormat.format("Variable $0 cannot be resolved.", new Object[]{key});
                    throw new RuntimeException(msg);
                }
                if (value != null) {
                    sb.append(valuePrefix);
                    sb.append(value);
                    sb.append(valueSuffix);
                } else {
                    sb.append(defaultPrefix);
                    sb.append(defaultSuffix);
                }
                i = end;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int getQMarkExpr(String text, int iStart, StringBuffer valueBuf, StringBuffer defaultBuf) {
        int ret = iStart;
        if (text.length() > iStart && text.charAt(iStart) == '?') {
            int iEnd;
            if ((iEnd = text.indexOf(63, ++iStart)) < 0) {
                String msg = MsgFormat.format("Expected '?' in variable expression ${{0}}.", new Object[]{text});
                throw new RuntimeException(msg);
            }
            valueBuf.append(text.substring(iStart, iEnd));
            iStart = iEnd + 1;
            iEnd = text.indexOf(63, iStart);
            if (iEnd < 0) {
                String msg = MsgFormat.format("Expected '?' in variable expression ${{0}}.", new Object[]{text});
                throw new RuntimeException(msg);
            }
            defaultBuf.append(text.substring(iStart, iEnd));
            ret = iEnd + 1;
        }
        return ret;
    }

    public static boolean saveSettings(SettingResolver resolver) {
        if (resolver == null) {
            resolver = SettingUtil.getStandardResolver();
        }
        return resolver.saveSettings(null);
    }

    public static Properties expandProperties(Properties props) {
        Properties ret = new Properties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            value = SettingUtil.expandVariables(value, true, SettingUtil.getStandardResolver());
            ret.put(key, value);
        }
        return ret;
    }

    public static Properties overwriteProperties(Properties props) {
        Properties ret = new Properties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            String replacement = SettingUtil.getStringSetting(key, value);
            ret.put(key, replacement);
        }
        return ret;
    }

    public static String getStringSetting(String name) {
        return SettingUtil.getStringSetting(name, null, SettingUtil.getStandardResolver());
    }

    public static String getStringSetting(String name, String dflt) {
        return SettingUtil.getStringSetting(name, dflt, SettingUtil.getStandardResolver());
    }

    public static boolean getBooleanSetting(String name, boolean dflt) {
        return SettingUtil.getBooleanSetting(name, dflt, SettingUtil.getStandardResolver());
    }

    public static SettingProvider setStringSetting(String name, String value) {
        return SettingUtil.setStringSetting(name, value, SettingUtil.getStandardResolver());
    }

    public static int getIntSetting(String name, int dflt) {
        return SettingUtil.getIntSetting(name, dflt, SettingUtil.getStandardResolver());
    }

    public static SettingProvider setBooleanSetting(String name, boolean value) {
        return SettingUtil.setBooleanSetting(name, value, SettingUtil.getStandardResolver());
    }

    public static SettingProvider setIntSetting(String name, int value) {
        return SettingUtil.setIntSetting(name, value, SettingUtil.getStandardResolver());
    }

    public static String getMandatoryStringSetting(String name) {
        String ret = SettingUtil.getStringSetting(name, null, SettingUtil.getStandardResolver());
        if (ret == null) {
            String msg = LogUtil.error(SettingUtil.class, "Setting value $0 has not been configured.", new Object[]{name});
            throw new RuntimeException(msg);
        }
        return ret;
    }

    public static boolean getMandatoryBooleanSetting(String name) {
        Object value = SettingUtil.getStandardResolver().getSetting(name, null);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
        }
        String msg = LogUtil.error(SettingUtil.class, "Setting value $0 has not been configured.", new Object[]{name});
        throw new RuntimeException(msg);
    }

    public static int getMandatoryIntSetting(String name) {
        Object value = SettingUtil.getStandardResolver().getSetting(name, null);
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        String msg = LogUtil.error(SettingUtil.class, "Setting value $0 has not been configured.", new Object[]{name});
        throw new RuntimeException(msg);
    }

    public static String expandVariables(String s, boolean mandatory) {
        return SettingUtil.expandVariables(s, mandatory, SettingUtil.getStandardResolver());
    }

    public static boolean saveSettings() {
        return standardResolver.saveSettings(null);
    }
}

