/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string;

import java.util.ArrayList;
import java.util.List;
import org.openbp.common.CollectionUtil;

public class StringReplacer {
    private boolean trim;
    private boolean ignoreCase;
    private String[] patterns;
    private int[] patLens;
    private List vPattern;
    private String[] replacements;
    private List vReplacements;

    public void addReplacement(String pattern, String replacement) {
        this.patterns = null;
        this.replacements = null;
        if (this.vPattern == null) {
            this.vPattern = new ArrayList();
        }
        this.vPattern.add(pattern);
        if (this.vReplacements == null) {
            this.vReplacements = new ArrayList();
        }
        this.vReplacements.add(replacement);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public String process(String s) {
        this.prepare();
        int len = s.length();
        StringBuffer retVal = new StringBuffer(len);
        boolean seenSpace = false;
        boolean seenNewLine = false;
        int nPattern = this.patterns != null ? this.patterns.length : 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (this.trim) {
                if (c == ' ' || c == '\t') {
                    if (seenSpace) continue;
                    seenSpace = true;
                    retVal.append(' ');
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    if (seenNewLine) continue;
                    seenNewLine = true;
                    seenSpace = true;
                    retVal.append(c == '\r' ? "\r\n" : "\n");
                    continue;
                }
                seenSpace = false;
                seenNewLine = false;
            }
            if (nPattern != 0) {
                int iPattern;
                for (iPattern = 0; iPattern < nPattern && !s.regionMatches(this.ignoreCase, i, this.patterns[iPattern], 0, this.patLens[iPattern]); ++iPattern) {
                }
                if (iPattern < nPattern) {
                    String value = this.replacements[iPattern];
                    if (value != null) {
                        retVal.append(value);
                    }
                    i += this.patLens[iPattern] - 1;
                    continue;
                }
            }
            retVal.append(c);
        }
        return retVal.toString();
    }

    private void prepare() {
        if (this.patterns == null && this.vPattern != null) {
            this.patterns = CollectionUtil.toStringArray(this.vPattern);
            if (this.patterns != null) {
                int nPattern = this.patterns.length;
                this.patLens = new int[nPattern];
                for (int i = 0; i < nPattern; ++i) {
                    this.patLens[i] = this.patterns[i].length();
                }
            }
        }
        if (this.replacements == null && this.vReplacements != null) {
            this.replacements = CollectionUtil.toStringArray(this.vReplacements);
        }
    }
}

