/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openbp.common.string.StringUtil;

public final class TextUtil {
    private static final char[] TRIM_CHARACTERS = new char[]{' ', '\t', '\r'};

    private TextUtil() {
    }

    public static String extractSummary(String text) {
        char c;
        if (text == null) {
            return null;
        }
        int len = (text = text.trim()).length();
        if (len == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean seenSpace = false;
        for (int i = 0; i < len && (c = text.charAt(i)) != '\n'; ++i) {
            if (Character.isWhitespace(c)) {
                if (seenSpace) continue;
                sb.append(' ');
                seenSpace = true;
                continue;
            }
            sb.append(c);
            seenSpace = false;
            if (c == '.' && (i + 1 >= len || Character.isWhitespace(text.charAt(i + 1)))) break;
        }
        return sb.length() != 0 ? sb.toString() : null;
    }

    public static List breakIntoLines(String s, boolean trim, int maxLength) {
        ArrayList<String> lines = new ArrayList<String>();
        if (s == null) {
            return lines;
        }
        String restString = s;
        while (restString != null) {
            int lineEnd = restString.indexOf(10);
            String line = null;
            if (lineEnd == -1) {
                line = restString;
                restString = null;
            } else {
                line = restString.substring(0, lineEnd);
                restString = restString.length() > lineEnd + 1 ? restString.substring(lineEnd + 1) : null;
            }
            if (trim) {
                line = StringUtil.trim(line, TRIM_CHARACTERS);
            }
            if (maxLength >= 0 && line.length() > maxLength) {
                BreakIterator iterator = null;
                while ((line = line.trim()).length() != 0) {
                    int next;
                    if (iterator == null) {
                        iterator = BreakIterator.getLineInstance();
                    }
                    iterator.setText(line);
                    int breakPos = 0;
                    while ((next = iterator.next()) != -1) {
                        if (next < maxLength) {
                            breakPos = next;
                            continue;
                        }
                        if (breakPos != 0) break;
                        breakPos = next;
                        break;
                    }
                    String singleLine = line.substring(0, breakPos).trim();
                    if (lines.size() != 0 || line.trim().length() != 0) {
                        lines.add(singleLine);
                    }
                    line = line.substring(breakPos);
                }
                continue;
            }
            if (lines.size() == 0 && line.trim().length() == 0) continue;
            lines.add(line);
        }
        int i = lines.size();
        while (--i >= 0 && "".equals(lines.get(i))) {
            lines.remove(i);
        }
        return lines;
    }

    public static String concatLines(Iterator lineIterator) {
        StringBuffer sb = new StringBuffer();
        while (lineIterator.hasNext()) {
            String line = (String)lineIterator.next();
            if (line == null) continue;
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(line);
        }
        return sb.length() != 0 ? sb.toString() : null;
    }

    public static String encodeMultiLineString(String s) {
        if (s != null) {
            if ((s = s.trim()).length() == 0) {
                s = null;
            } else if (s.indexOf(10) >= 0 || s.indexOf(9) >= 0) {
                StringBuffer sb = new StringBuffer();
                boolean seenSpace = false;
                int n = s.length();
                for (int i = 0; i < n; ++i) {
                    char c = s.charAt(i);
                    if (c == '\n') {
                        sb.append("\\n");
                        seenSpace = true;
                        continue;
                    }
                    if (c == '\t') {
                        sb.append("\\t");
                        seenSpace = true;
                        continue;
                    }
                    if (c == '\\') {
                        sb.append("\\\\");
                        continue;
                    }
                    if (c == ' ') {
                        if (seenSpace) {
                            sb.append("\\s");
                            continue;
                        }
                        sb.append(" ");
                        seenSpace = true;
                        continue;
                    }
                    sb.append(c);
                    seenSpace = false;
                }
                s = sb.toString();
            }
        }
        return s;
    }

    public static String decodeMultiLineString(String s) {
        if (s != null) {
            if ((s = s.trim()).length() == 0) {
                s = null;
            } else if (s.indexOf(10) >= 0 || s.indexOf(92) >= 0) {
                StringBuffer sb = new StringBuffer();
                boolean eatSpace = false;
                int n = s.length();
                for (int i = 0; i < n; ++i) {
                    char c = s.charAt(i);
                    if (c == '\\') {
                        if (i + 1 < n) {
                            char c2 = s.charAt(i + 1);
                            switch (c2) {
                                case 'n': {
                                    c = '\n';
                                    ++i;
                                    eatSpace = true;
                                    break;
                                }
                                case 't': {
                                    c = '\t';
                                    ++i;
                                    eatSpace = true;
                                    break;
                                }
                                case 's': {
                                    c = ' ';
                                    ++i;
                                    eatSpace = true;
                                    break;
                                }
                                case '\\': {
                                    c = '\\';
                                    ++i;
                                    break;
                                }
                                default: {
                                    eatSpace = false;
                                    break;
                                }
                            }
                        } else {
                            eatSpace = false;
                        }
                    } else if (c == ' ' || c == '\t' || c == '\n') {
                        if (eatSpace) continue;
                        if (c == ' ' || c == '\t' || c == '\n') {
                            c = ' ';
                            eatSpace = true;
                        }
                    } else {
                        eatSpace = false;
                    }
                    sb.append(c);
                }
                s = sb.length() != 0 ? sb.toString() : null;
            }
        }
        return s;
    }

    public static String convertToHTML(String[] paragraphs, boolean boldTitle, int separatorPos, int maxLength) {
        if (paragraphs == null || paragraphs.length == 0) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        output.append("<html>");
        boolean lineAdded = false;
        for (int i = 0; i < paragraphs.length; ++i) {
            if (paragraphs[i] == null) continue;
            if (lineAdded) {
                output.append("<br>");
            }
            if (i == separatorPos + 1 && lineAdded) {
                output.append("<hr>");
            }
            if (i == 0 && boldTitle) {
                output.append("<b>");
            }
            TextUtil.appendHTMLLine(paragraphs[i], output, maxLength);
            lineAdded = true;
            if (i != 0 || !boldTitle) continue;
            output.append("</b>");
        }
        output.append("</html>");
        return output.toString();
    }

    public static void appendHTMLLine(String line, StringBuffer output, int maxLength) {
        List lines = TextUtil.breakIntoLines(line, false, maxLength);
        int n = lines.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                output.append("<br>");
            }
            output.append((String)lines.get(i));
        }
    }
}

