/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string.base64;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JLabel;
import org.openbp.common.string.base64.Base64;

public class Base64Example {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i;
        JLabel originalLabel = new JLabel("Base64 is great.");
        byte[] originalBytes = new byte[]{-2, -1, 0, 1, 2};
        System.out.println("Original JLabel: " + originalLabel);
        String encLabel = Base64.encodeObject(originalLabel);
        String encGZLabel = Base64.encodeObject(originalLabel, 2);
        String encGZDontBreakLines = Base64.encodeObject(originalLabel, 10);
        System.out.println("JLabel, encoded ( " + encLabel.getBytes().length + " bytes):\n" + encLabel);
        System.out.println("JLabel, gzipped and encoded ( " + encGZLabel.getBytes().length + " bytes):\n" + encGZLabel);
        System.out.println("JLabel, gzipped, encoded, no line breaks (not Base 64 compliant) ( " + encGZDontBreakLines.getBytes().length + " bytes):\n" + encGZDontBreakLines);
        Object objLabel = Base64.decodeToObject(encLabel);
        Object objGZLabel = Base64.decodeToObject(encGZLabel);
        Object objGZDontBreakLines = Base64.decodeToObject(encGZDontBreakLines);
        System.out.println("Encoded JLabel -> decoded: " + objLabel);
        System.out.println("Encoded, gzipped JLabel -> decoded: " + objGZLabel);
        System.out.println("Encoded, gzipped, no line breaks JLabel -> decoded: " + objGZDontBreakLines);
        System.out.println("\n\nOriginal array: ");
        for (int i2 = 0; i2 < originalBytes.length; ++i2) {
            System.out.print(originalBytes[i2] + " ");
        }
        System.out.println();
        String encBytes = Base64.encodeBytes(originalBytes);
        String encGZBytes = Base64.encodeBytes(originalBytes, 2);
        System.out.println("Bytes, encoded ( " + encBytes.getBytes().length + " bytes):\n" + encBytes);
        System.out.println("Bytes, gzipped and encoded ( " + encGZBytes.getBytes().length + " bytes):\n" + encGZBytes);
        byte[] decBytes = Base64.decode(encBytes);
        byte[] decGZBytes = Base64.decode(encGZBytes);
        System.out.println("Encoded Bytes -> decoded: ");
        for (i = 0; i < decBytes.length; ++i) {
            System.out.print(decBytes[i] + " ");
        }
        System.out.println();
        System.out.println("Encoded Bytes, gzipped -> decoded: ");
        for (i = 0; i < decGZBytes.length; ++i) {
            System.out.print(decGZBytes[i] + " ");
        }
        System.out.println();
        System.out.println("\n\nSuspend/Resume Base64.OutputStream");
        FilterOutputStream b64os = null;
        PrintStream ps = null;
        try {
            ps = new PrintStream(System.out);
            b64os = new Base64.OutputStream(ps, 1);
            ((Base64.OutputStream)b64os).suspendEncoding();
            b64os.write(new String("<mydata>").getBytes());
            ((Base64.OutputStream)b64os).resumeEncoding();
            b64os.write(originalBytes);
            ((Base64.OutputStream)b64os).suspendEncoding();
            b64os.write(new String("</mydata>\n\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (b64os != null) {
                    b64os.flush();
                }
            }
            catch (Exception e) {}
        }
        System.out.print("\n\nWriting to file example.gz.txt...");
        ObjectOutputStream oos = null;
        DeflaterOutputStream gzos = null;
        Base64.OutputStream b64os2 = null;
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream("example.gz.txt");
            bos = new BufferedOutputStream(fos);
            b64os2 = new Base64.OutputStream(bos, 1);
            gzos = new GZIPOutputStream(b64os2);
            oos = new ObjectOutputStream(gzos);
            oos.writeObject(System.getProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {}
            try {
                if (gzos != null) {
                    gzos.close();
                }
            }
            catch (Exception e) {}
            try {
                if (b64os2 != null) {
                    b64os2.close();
                }
            }
            catch (Exception e) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {}
            System.out.println("Done.");
        }
        System.out.print("\n\nReading from file example.gz.txt...");
        ObjectInputStream ois = null;
        GZIPInputStream gzis = null;
        FilterInputStream b64is = null;
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("example.gz.txt");
            bis = new BufferedInputStream(fis);
            b64is = new Base64.InputStream(bis, 0);
            gzis = new GZIPInputStream(b64is);
            ois = new ObjectInputStream(gzis);
            System.out.print(ois.readObject());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {}
            try {
                if (gzis != null) {
                    gzis.close();
                }
            }
            catch (Exception e) {}
            try {
                if (b64is != null) {
                    b64is.close();
                }
            }
            catch (Exception e) {}
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {}
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
            System.out.println("Done.");
        }
        System.out.print("\n\nWriting to file example.txt...");
        oos = null;
        Base64.OutputStream b64os3 = null;
        BufferedOutputStream bos2 = null;
        FileOutputStream fos2 = null;
        try {
            fos2 = new FileOutputStream("example.txt");
            bos2 = new BufferedOutputStream(fos2);
            b64os3 = new Base64.OutputStream(bos2, 1);
            oos = new ObjectOutputStream(b64os3);
            oos.writeObject(System.getProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {}
            try {
                if (b64os3 != null) {
                    b64os3.close();
                }
            }
            catch (Exception e) {}
            try {
                if (bos2 != null) {
                    bos2.close();
                }
            }
            catch (Exception e) {}
            try {
                if (fos2 != null) {
                    fos2.close();
                }
            }
            catch (Exception e) {}
            System.out.println("Done.");
        }
        System.out.println("\nExamples completed.");
    }
}

