/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.util.UUID;
import org.openbp.common.util.ByteArrayUtil;

public class CheckedIdGenerator {
    private static CheckedIdGenerator singletonInstance;
    private static int maxLength;

    public static synchronized CheckedIdGenerator getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new CheckedIdGenerator();
        }
        return singletonInstance;
    }

    private CheckedIdGenerator() {
    }

    public String getID() {
        UUID id = UUID.randomUUID();
        byte ck = CheckedIdGenerator.getNewIdChecksum(id);
        return id.toString() + "-" + ByteArrayUtil.toHexString(ck);
    }

    public static final synchronized int getMaxLength() {
        if (maxLength == -1) {
            maxLength = CheckedIdGenerator.getInstance().getID().length();
        }
        return maxLength;
    }

    public static boolean checksumOk(String id) {
        byte ck = CheckedIdGenerator.getNewIdChecksum(id);
        if (id.length() < 39) {
            return false;
        }
        byte s = CheckedIdGenerator.getEmbeddedIdChecksum(id);
        return ck == s;
    }

    public static byte getEmbeddedIdChecksum(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id should not be null");
        }
        if (id.length() < CheckedIdGenerator.getMaxLength()) {
            throw new IllegalArgumentException("id is to short");
        }
        return ByteArrayUtil.fromHex(id.substring(37));
    }

    public static byte getNewIdChecksum(String ids) {
        if (ids == null) {
            throw new IllegalArgumentException("id should not be null");
        }
        if (ids.length() < 36) {
            throw new IllegalArgumentException("id is to short");
        }
        String idStr = ids.length() > 36 ? ids.substring(0, 36) : ids;
        return CheckedIdGenerator.getNewIdChecksum(UUID.fromString(idStr));
    }

    private static byte getNewIdChecksum(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("id should not be null");
        }
        CS cs = new CS();
        cs.update(ByteArrayUtil.toBytes(id.getMostSignificantBits()));
        cs.update(ByteArrayUtil.toBytes(id.getLeastSignificantBits()));
        return (byte)(cs.getValue() & 0xFF);
    }

    public static void main(String[] args) {
        CheckedIdGenerator idg = CheckedIdGenerator.getInstance();
        for (int i = 0; i < 10; ++i) {
            System.out.println(idg.getID());
        }
        System.out.println(CheckedIdGenerator.checksumOk(idg.getID()));
        System.out.println(CheckedIdGenerator.checksumOk(idg.getID().substring(0, 37) + "00"));
        System.out.println(CheckedIdGenerator.getMaxLength());
    }

    static {
        maxLength = -1;
    }

    private static class CS {
        int sum;

        public void update(byte[] b) {
            for (int i = 0; i < b.length; ++i) {
                this.sum += b[i];
            }
        }

        public int getValue() {
            return this.sum;
        }
    }
}

