/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.classloader.ClassLoaderObjectInputStream;
import org.openbp.common.generic.Copyable;

public final class CopyUtil {
    public static final int CLONE_NONE = 0;
    public static final int CLONE_KEYS = 1;
    public static final int CLONE_VALUES = 2;
    public static final int CLONE_ALL = 3;

    private CopyUtil() {
    }

    public static Object createNew(Object object) throws CloneNotSupportedException {
        if (object != null) {
            Class<?> cls = object.getClass();
            try {
                return cls.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new CloneNotSupportedException("Error creating new object of type '" + cls.getName() + "' (access): " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new CloneNotSupportedException("Error creating new object of type '" + cls.getName() + "' (instantiation): " + e.getMessage());
            }
        }
        return null;
    }

    public static Object copyObject(Object object, int copyMode, ClassLoader classLoader) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        Object newObject = null;
        if (object instanceof Copyable) {
            if (copyMode == 2) {
                newObject = ((Copyable)object).clone();
            } else {
                try {
                    newObject = object.getClass().newInstance();
                }
                catch (InstantiationException e) {
                    ExceptionUtil.printTrace(e);
                    throw new CloneNotSupportedException("Cannot clone object of type '" + object.getClass().getName() + "'. No default constructor available.");
                }
                catch (IllegalAccessException e) {
                    ExceptionUtil.printTrace(e);
                    throw new CloneNotSupportedException("Cannot clone object of type '" + object.getClass().getName() + "'. Cannot access default constructor.");
                }
                ((Copyable)newObject).copyFrom(object, copyMode);
            }
        } else if (object instanceof Cloneable) {
            try {
                Method method = object.getClass().getMethod("clone", null);
                newObject = method.invoke(object, (Object[])null);
            }
            catch (Exception e) {
                ExceptionUtil.printTrace(e);
                throw new CloneNotSupportedException("Cannot clone object of type '" + object.getClass().getName() + "'");
            }
        } else if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(object);
                oos.flush();
                oos.close();
                byte[] bytes = bos.toByteArray();
                ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(new ByteArrayInputStream(bytes));
                ois.setClassLoader(classLoader);
                newObject = ois.readObject();
            }
            catch (IOException e) {
                ExceptionUtil.printTrace(e);
                throw new CloneNotSupportedException("Cannot clone object of type '" + object.getClass().getName() + "'");
            }
            catch (ClassNotFoundException e) {
                ExceptionUtil.printTrace(e);
                throw new CloneNotSupportedException("Cannot clone object of type '" + object.getClass().getName() + "'");
            }
        } else {
            throw new CloneNotSupportedException("Cannot clone object of type '" + object.getClass().getName() + "'");
        }
        return newObject;
    }

    public static Collection copyCollection(Collection source, int copyMode) throws CloneNotSupportedException {
        Collection copy;
        if (source == null) {
            return null;
        }
        try {
            copy = (Collection)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw new CloneNotSupportedException("Cannot clone object of type '" + source.getClass().getName() + "'");
        }
        for (Object element : source) {
            if ((copyMode & 2) != 0) {
                element = CopyUtil.copyObject(element, 2, null);
            }
            copy.add(element);
        }
        return copy;
    }

    public static Map copyMap(Map source, int copyMode) throws CloneNotSupportedException {
        Map copy;
        if (source == null) {
            return null;
        }
        try {
            copy = (Map)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw new CloneNotSupportedException("Cannot clone object of type '" + source.getClass().getName() + "'");
        }
        Iterator itValues = source.values().iterator();
        Iterator itKeys = source.keySet().iterator();
        while (itValues.hasNext()) {
            Object key = itKeys.next();
            Object value = itValues.next();
            if ((copyMode & 1) != 0) {
                key = CopyUtil.copyObject(key, 2, null);
            }
            if ((copyMode & 2) != 0) {
                value = CopyUtil.copyObject(value, 2, null);
            }
            copy.put(key, value);
        }
        return copy;
    }
}

