/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class DateComparator
implements Comparator {
    public static final int COMPARE_COMPLETE = -1;
    public static final int COMPARE_MINUTES = 0;
    public static final int COMPARE_HOURS = 1;
    public static final int COMPARE_DAYS = 2;
    public static final int COMPARE_MONTH = 3;
    public static final int COMPARE_YEAR = 4;
    public static final int[] CALENDAR_TYPES = new int[]{12, 10, 5, 2, 1};
    private int dateElement = -1;

    public void setDateElementToCompare(int dateElement) {
        this.dateElement = dateElement;
    }

    public int compare(Object o1, Object o2) {
        if (this.dateElement == -1) {
            return ((Date)o1).compareTo((Date)o2);
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime((Date)o1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime((Date)o2);
        for (int i = 5; i > this.dateElement; --i) {
            int result = this.compare(c1.get(CALENDAR_TYPES[i - 1]), c2.get(CALENDAR_TYPES[i - 1]));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int compare(int i1, int i2) {
        if (i1 > i2) {
            return 1;
        }
        if (i1 < i2) {
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        try {
            DateComparator dc = new DateComparator();
            dc.setDateElementToCompare(3);
            DateFormat df = DateFormat.getDateInstance(3, Locale.GERMANY);
            int i = dc.compare(df.parse("10.11.2002 10:30"), df.parse("10.11.2002 8:25"));
            System.out.println(i);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

