/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openbp.common.util.DisposalListener;

public class ExpirationHashtable {
    private Hashtable valueDescriptors = new Hashtable();
    private long defaultTimeout = 0L;
    private DisposalListener disposalListener;
    private static CleanupThread cleanupThread;

    public ExpirationHashtable(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
        if (cleanupThread == null) {
            cleanupThread = new CleanupThread();
            cleanupThread.start();
        }
        cleanupThread.register(this);
    }

    public boolean containsKey(Object key) {
        return this.valueDescriptors.containsKey(key);
    }

    public Set entrySet() {
        return this.valueDescriptors.entrySet();
    }

    public Set keySet() {
        return this.valueDescriptors.keySet();
    }

    public Collection values() {
        return this.valueDescriptors.values();
    }

    public Enumeration elements() {
        return new ValueEnumeration(this.valueDescriptors.elements());
    }

    public Object get(Object key) {
        ValueDescriptor valueDescriptor = (ValueDescriptor)this.valueDescriptors.get(key);
        if (valueDescriptor != null) {
            return valueDescriptor.getValue();
        }
        return null;
    }

    public Enumeration keys() {
        return this.valueDescriptors.keys();
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, this.defaultTimeout);
    }

    public Object put(Object key, Object value, long timeout) {
        ValueDescriptor valueDescriptor = this.valueDescriptors.put(key, new ValueDescriptor(value, timeout));
        return valueDescriptor == null ? null : valueDescriptor.getValue();
    }

    public Object remove(Object key) {
        ValueDescriptor valueInformation = (ValueDescriptor)this.valueDescriptors.remove(key);
        return valueInformation == null ? null : valueInformation.getValue();
    }

    public void setDisposalListener(DisposalListener disposalListener) {
        this.disposalListener = disposalListener;
    }

    public int size() {
        return this.valueDescriptors.size();
    }

    private static final class ValueEnumeration
    implements Enumeration {
        private Enumeration valueDescriptorEnumeration;

        public ValueEnumeration(Enumeration valueDescriptorEnumeration) {
            this.valueDescriptorEnumeration = valueDescriptorEnumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.valueDescriptorEnumeration.hasMoreElements();
        }

        public Object nextElement() {
            ValueDescriptor valueDescriptor = (ValueDescriptor)this.valueDescriptorEnumeration.nextElement();
            return valueDescriptor == null ? null : valueDescriptor.getValue();
        }
    }

    private static class ValueDescriptor {
        private long lastAccessTime;
        private long timeout;
        private Object value;

        public ValueDescriptor(Object value, long timeout) {
            this.value = value;
            this.lastAccessTime = System.currentTimeMillis();
            this.timeout = timeout;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public Object getValue() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.value;
        }
    }

    private static class CleanupThread
    extends Thread {
        private Map targets;

        public CleanupThread() {
            super("Expiration table cleanup");
            this.setDaemon(true);
            this.targets = new WeakHashMap();
        }

        public void register(ExpirationHashtable ht) {
            this.targets.put(ht, ht);
        }

        @Override
        public void run() {
            while (true) {
                for (ExpirationHashtable ht : this.targets.keySet()) {
                    this.cleanup(ht);
                }
                try {
                    CleanupThread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        private void cleanup(ExpirationHashtable ht) {
            long now = System.currentTimeMillis();
            Enumeration keys = ht.valueDescriptors.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                ValueDescriptor valueInformation = (ValueDescriptor)ht.valueDescriptors.get(key);
                long timeout = valueInformation.getTimeout();
                if (timeout <= 0L || now <= valueInformation.getLastAccessTime() + timeout) continue;
                if (ht.disposalListener != null) {
                    ht.disposalListener.onDispose(key);
                }
                if (ht.valueDescriptors == null) continue;
                ht.valueDescriptors.remove(key);
            }
        }
    }
}

