/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparableComparator;

public class SortingArrayList
extends ArrayList {
    private Comparator comparator = ComparableComparator.getInstance();
    private boolean autoSort = true;

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public boolean isAutoSort() {
        return this.autoSort;
    }

    public void setAutoSort(boolean autoSort) {
        this.autoSort = autoSort;
    }

    public void sort() {
        if (this.size() > 1) {
            if (this.comparator != null) {
                Collections.sort(this, this.comparator);
            } else {
                Collections.sort(this);
            }
        }
    }

    protected void autoSort() {
        if (this.autoSort) {
            this.sort();
        }
    }

    @Override
    public boolean add(Object o) {
        boolean ret = super.add(o);
        this.autoSort();
        return ret;
    }

    @Override
    public void add(int index, Object element) {
        super.add(index, element);
        this.autoSort();
    }

    @Override
    public boolean addAll(Collection c) {
        boolean ret = super.addAll(c);
        this.autoSort();
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        boolean ret = super.addAll(index, c);
        this.autoSort();
        return ret;
    }
}

