/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class WeakArrayList
extends AbstractList {
    private ArrayList list;

    public WeakArrayList() {
        this.list = new ArrayList();
    }

    public WeakArrayList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    @Override
    public Object get(int index) {
        return this.resolveReference(this.list.get(index));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object set(int index, Object element) {
        WeakReference<Object> o = element != null ? new WeakReference<Object>(element) : null;
        return this.resolveReference(this.list.set(index, o));
    }

    @Override
    public void add(int index, Object element) {
        WeakReference<Object> o = element != null ? new WeakReference<Object>(element) : null;
        this.list.add(index, o);
    }

    @Override
    public Object remove(int index) {
        return this.resolveReference(this.list.remove(index));
    }

    public void addHardReference(Object element) {
        this.list.add(this.list.size(), element);
    }

    public void addHardReference(int index, Object element) {
        this.list.add(index, element);
    }

    public List createHardList() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            Object tmp = this.get(i);
            if (tmp == null) continue;
            result.add(tmp);
        }
        return result;
    }

    public void trim() {
        int i = this.size();
        while (--i >= 0) {
            if (this.get(i) != null) continue;
            this.remove(i);
        }
    }

    private Object resolveReference(Object o) {
        if (o != null && o instanceof WeakReference) {
            return ((WeakReference)o).get();
        }
        return o;
    }
}

