/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util.iterator;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class DoubleSafeIterator
implements Iterator {
    private Iterator internal;
    private List visited = new Vector();
    private Object next = null;

    public DoubleSafeIterator(Iterator base) {
        this.internal = base;
        if (this.internal.hasNext()) {
            this.skipAhead();
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException("no more elements");
        }
        Object result = this.next;
        this.visited.add(this.next);
        this.skipAhead();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove operation not supported by ArrayIterator");
    }

    protected void skipAhead() {
        this.next = this.internal.next();
        while (this.visited.contains(this.next)) {
            if (this.internal.hasNext()) {
                this.next = this.internal.next();
                continue;
            }
            this.next = null;
            break;
        }
    }
}

