/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.common;

import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

/**
 * Spring framework utilities.
 *
 * @author Heiko Erhardt
 */
public final class SpringUtil
{
	/**
	 * Private constructor prevents instantiation.
	 */
	private SpringUtil()
	{
	}

	/**
	 * Performs Spring autowiring for a non-Spring-managed bean.
	 * This will resolve the @Autowired annotations of the bean members.
	 *
	 * @param bean Bean to wire
	 * @param applicationContext Application context that will be used to resolve autowired bean members
	 */
	public static void autowireBean(Object bean, ApplicationContext applicationContext)
	{
		if (applicationContext != null && bean != null)
		{
			AutowireCapableBeanFactory bf = applicationContext.getAutowireCapableBeanFactory();
			bf.autowireBean(bean);
		}
	}
}
