/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.openbp.common.string.StringUtil;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String getNestedMessage(Throwable t) {
        ArrayList<String> msgs = new ArrayList<String>();
        while (t != null) {
            String msg = StringUtil.trimNull(t.getMessage());
            if (msg != null) {
                int i = msg.indexOf("; nested exception is");
                if (i >= 0) {
                    msg = msg.substring(0, i);
                }
                if (t instanceof ClassNotFoundException) {
                    msg = "Class not found: " + msg;
                }
                if (!msgs.contains(msg)) {
                    msgs.add(msg);
                }
            }
            t = ExceptionUtil.tryNestedException(t);
        }
        int n = msgs.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return (String)msgs.get(0);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String msg = (String)msgs.get(i);
            if (i > 0) {
                sb.append("\n\n");
            }
            sb.append(msg);
        }
        return sb.toString();
    }

    public static String getNestedTrace(Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        Throwable cause = null;
        Throwable t = throwable;
        while (t != null) {
            if (t != throwable) {
                sb.append("\n\tcaused by: ");
            }
            sb.append(t.getClass().getName());
            String msg = StringUtil.trimNull(t.getMessage());
            if (msg != null) {
                sb.append(": ");
                sb.append(msg);
            }
            cause = t;
            t = ExceptionUtil.tryNestedException(t);
        }
        if (cause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            cause.printStackTrace(pw);
            String trace = sw.getBuffer().toString();
            int i = trace.indexOf(9);
            if (i > 0) {
                trace = trace.substring(i);
            }
            sb.append("\n");
            sb.append(trace);
        }
        return sb.toString();
    }

    public static List getNestedExceptions(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        Throwable t = throwable;
        while (t != null && !list.contains(t)) {
            list.add(t);
            t = ExceptionUtil.tryNestedException(t);
        }
        return list;
    }

    public static Throwable getNestedException(Throwable t) {
        Throwable nestedException;
        while ((nestedException = ExceptionUtil.tryNestedException(t)) != null) {
            t = nestedException;
        }
        return t;
    }

    public static Throwable findNestedException(Throwable t, String className) {
        while (t != null) {
            if (t.getClass().getName().equals(className)) {
                return t;
            }
            t = ExceptionUtil.tryNestedException(t);
        }
        return t;
    }

    public static void printTrace(Throwable t) {
        ExceptionUtil.printTrace(null, t);
    }

    public static void printTrace(String msg, Throwable t) {
        if (msg != null) {
            System.err.print(msg);
            System.err.println();
        }
        if (t != null) {
            String trace = ExceptionUtil.getNestedTrace(t);
            System.err.println(trace);
        }
    }

    private static Throwable tryNestedException(Throwable t) {
        Throwable nestedException = ExceptionUtil.tryNestedException(t, "getException");
        if (nestedException == null) {
            nestedException = ExceptionUtil.tryNestedException(t, "getTargetException");
        }
        if (nestedException == null) {
            nestedException = ExceptionUtil.tryNestedException(t, "getNestedException");
        }
        if (nestedException == null) {
            nestedException = ExceptionUtil.tryNestedException(t, "getRootCause");
        }
        if (nestedException == null) {
            nestedException = ExceptionUtil.tryNestedException(t, "getCause");
        }
        return nestedException;
    }

    private static Throwable tryNestedException(Throwable t, String methodName) {
        try {
            Method method = t.getClass().getMethod(methodName, null);
            Object ret = method.invoke((Object)t, new Object[0]);
            if (ret instanceof Throwable && ret != t) {
                return (Throwable)ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static RuntimeException extractRuntimeException(Throwable e) {
        RuntimeException re = null;
        if (e instanceof RuntimeException) {
            re = (RuntimeException)e;
        } else if (e instanceof RemoteException && e.getCause() instanceof RuntimeException) {
            re = (RuntimeException)e.getCause();
        }
        if (re == null) {
            re = e instanceof RuntimeException && e.getCause() != null ? new RuntimeException(e.getCause()) : new RuntimeException(e);
        }
        return re;
    }
}

