/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.classloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openbp.common.MsgFormat;
import org.openbp.common.classloader.ResourceEntry;
import org.openbp.common.classloader.XClassLoaderConfiguration;
import org.openbp.common.string.StringUtil;

public abstract class XClassLoaderBase
extends URLClassLoader {
    public static boolean DEBUG_LOAD_TIME = false;
    private static URL[] noUrls = new URL[0];
    protected XClassLoaderConfiguration configuration;
    private Hashtable classCache;
    private Map entries;
    private long loadClassTime;

    public XClassLoaderBase(XClassLoaderConfiguration configuration) throws Exception {
        super(noUrls);
        this.init(configuration);
    }

    protected XClassLoaderBase() {
        super(noUrls);
    }

    protected void init(XClassLoaderConfiguration configuration) throws Exception {
        if (configuration == null) {
            throw new IllegalArgumentException("Creation of classloader without configuration is not supported.");
        }
        this.configuration = (XClassLoaderConfiguration)configuration.clone();
        this.setupLogger();
        if (this.isLogEnabled("Info")) {
            configuration.printDebug(this);
        }
        this.classCache = new Hashtable(1000);
        this.entries = new HashMap(1000);
        this.scanRepositories();
    }

    public void rescan() throws Exception {
        this.entries.clear();
        this.scanRepositories();
    }

    public ClassLoader getParentClassLoader() {
        return this.configuration.getParentClassLoader();
    }

    public XClassLoaderConfiguration getConfiguration() {
        return this.configuration;
    }

    public ResourceEntry getResourceEntry(String key) {
        return (ResourceEntry)this.entries.get(key);
    }

    public void addResourceEntry(String key, ResourceEntry entry) {
        this.entries.put(key, entry);
    }

    protected void addResourceEntryForClass(String resourceName, ResourceEntry entry) {
        int index = resourceName.indexOf(".class");
        if (index >= 0) {
            String className = resourceName.substring(0, index);
            className = className.replace('/', '.');
            className = className.replace('\\', '.');
            this.addResourceEntry(className, entry);
        }
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> cls;
        Class<?> result = null;
        long time = 0L;
        if (DEBUG_LOAD_TIME && this.isLogEnabled("Debug")) {
            time = System.currentTimeMillis();
        }
        result = (cls = this.loadClassFromPath(className, resolve)) != null ? cls : this.findSystemClass(className);
        if (DEBUG_LOAD_TIME && this.isLogEnabled("Debug")) {
            time = System.currentTimeMillis() - time;
            this.loadClassTime += time;
            this.log("Debug", "loadClass('" + className + "') took " + time + " ms " + "(accumulated: " + this.loadClassTime + " ms)");
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        return this.getResourceFromPath(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.loadResourceFromPath(name);
    }

    protected synchronized Class loadClassFromPath(String className, boolean resolve) {
        boolean standardFirst;
        Class cls = this.loadClassFromCache(className);
        if (cls != null) {
            return cls;
        }
        boolean bl = standardFirst = (this.configuration.getTryStandardClassLoaderFirst() || this.configuration.getStandardPackages().containsClass(className)) && !this.configuration.getNonStandardPackages().containsClass(className);
        if (standardFirst) {
            cls = this.tryStandardLoaders(className);
            if (cls != null) {
                return cls;
            }
            cls = this.tryRepositories(className, resolve);
            if (cls != null) {
                return cls;
            }
        } else {
            cls = this.tryRepositories(className, resolve);
            if (cls != null) {
                return cls;
            }
            cls = this.tryStandardLoaders(className);
            if (cls != null) {
                return cls;
            }
        }
        this.log("Debug", "Unresolved class: {0}", className);
        return null;
    }

    private Class tryRepositories(String className, boolean resolve) {
        Class result = null;
        try {
            byte[] data = null;
            ResourceEntry entry = (ResourceEntry)this.entries.get(className);
            if (entry != null) {
                data = entry.getBytes();
                if (data != null) {
                    this.log("Debug", "Class resolved by custom loader: {0} from repository {1}", className, entry.getRepositoryUrl().toString());
                    result = this.createClass(className, data, resolve);
                    this.addClassToCache(className, result);
                }
            } else {
                this.log("Debug", "Class not found in any repository: {0}", className);
            }
        }
        catch (Exception e) {
            this.log("Error", "Exception loading class: {0}", className, e);
        }
        return result;
    }

    private Class tryStandardLoaders(String className) {
        Class<?> result = null;
        try {
            ClassLoader cl;
            result = this.configuration.getParentClassLoader() != null ? this.configuration.getParentClassLoader().loadClass(className) : ((cl = this.getClass().getClassLoader()) != null && cl != this ? cl.loadClass(className) : Class.forName(className));
            if (result != null) {
                this.addClassToCache(className, result);
                this.log("Debug", "Class resolved by standard loader: {0}", className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public Class createClass(String className, byte[] data, boolean resolve) {
        Class<?> clazz = this.defineClass(className, data, 0, data.length);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected InputStream loadResourceFromPath(String resourceName) {
        InputStream stream;
        this.log("Debug", "Loading resource: {0}", resourceName);
        try {
            byte[] data = null;
            String searchName = StringUtil.normalizePathName(resourceName);
            ResourceEntry entry = (ResourceEntry)this.entries.get(searchName);
            if (entry != null && (data = entry.getBytes()) != null) {
                this.log("Debug", "Resource resolved by custom loader: {0} from repository {1}", resourceName, entry.getRepositoryUrl().toString());
                return new ByteArrayInputStream(data);
            }
        }
        catch (Exception e) {
            this.log("Error", "Exception loading resource: {0}", resourceName, e);
        }
        if (this.configuration.getParentClassLoader() != null && (stream = this.configuration.getParentClassLoader().getResourceAsStream(resourceName)) != null) {
            this.log("Debug", "Resource resolved by standard loader: {0}", resourceName);
            return stream;
        }
        this.log("Debug", "Unresolved resource: {0}", resourceName);
        return null;
    }

    protected URL getResourceFromPath(String resourceName) {
        URL url;
        this.log("Debug", "Getting resource: {0}", resourceName);
        String searchName = StringUtil.normalizePathName(resourceName);
        ResourceEntry entry = (ResourceEntry)this.entries.get(searchName);
        if (entry != null) {
            URL url2 = entry.createURL();
            this.log("Debug", "Resource URL resolved by custom loader: {0}", url2.toString());
            return url2;
        }
        if (this.configuration.getParentClassLoader() != null && (url = this.configuration.getParentClassLoader().getResource(resourceName)) != null) {
            this.log("Debug", "Resource resolved by standard loader: {0}", resourceName);
            return url;
        }
        this.log("Debug", "Unresolved resource: {0}", resourceName);
        return null;
    }

    protected void addClassToCache(String className, Class cls) {
        this.classCache.put(className, cls);
    }

    protected Class loadClassFromCache(String className) {
        return (Class)this.classCache.get(className);
    }

    protected void scanRepositories() throws Exception {
        long time = 0L;
        if (DEBUG_LOAD_TIME && this.isLogEnabled("Debug")) {
            time = System.currentTimeMillis();
        }
        List repositories = this.configuration.getRepositories();
        int n = repositories.size();
        for (int i = 0; i < n; ++i) {
            String repositoryName = (String)repositories.get(i);
            File f = new File(repositoryName);
            try {
                String path = f.getAbsolutePath();
                if (f.isDirectory()) {
                    this.log("Info", "Adding directory: {0}", path);
                    this.scanDirectory(f, path);
                    continue;
                }
                if (!repositoryName.endsWith(".jar") && !repositoryName.endsWith(".zip")) continue;
                this.scanJarFile(f);
                continue;
            }
            catch (Exception e) {
                this.log("Error", "Exception adding repository to class path: {0}", repositoryName, e);
            }
        }
        if (DEBUG_LOAD_TIME && this.isLogEnabled("Debug")) {
            time = System.currentTimeMillis() - time;
            this.log("Debug", "scanRepositories took " + time + " ms.");
        }
    }

    private void scanDirectory(File dir, String basePath) throws Exception {
        int basePathLen = basePath.length();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir.getPath(), files[i]);
            if (f.isDirectory()) {
                this.scanDirectory(f, basePath);
                continue;
            }
            String path = f.getAbsolutePath();
            String resourceName = path.substring(basePathLen + 1);
            if (this.entries.get(resourceName = StringUtil.normalizePathName(resourceName)) != null) continue;
            byte[] content = XClassLoaderBase.readContent(f);
            ResourceEntry entry = new ResourceEntry(f.toURL(), content);
            this.addResourceEntry(resourceName, entry);
            this.addResourceEntryForClass(resourceName, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJarFile(File f) throws Exception {
        String zipFileName = f.getAbsolutePath();
        this.log("Info", "Adding zip file: {0}", zipFileName);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(zipFileName);
            this.scanJarFile(new BufferedInputStream(fis), f.toURL());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJarFile(InputStream in, URL jarFileUrl) throws Exception {
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            zis = new ZipInputStream(new BufferedInputStream(in));
            while ((ze = zis.getNextEntry()) != null) {
                int nRead;
                int size;
                String resourceName = ze.getName();
                if (this.entries.get(resourceName) != null || (size = (int)ze.getSize()) == 0) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[4096];
                while ((nRead = zis.read(buffer)) > 0) {
                    bos.write(buffer, 0, nRead);
                }
                byte[] content = bos.toByteArray();
                URL jarEntryUrl = XClassLoaderBase.buildJarEntryUrl(jarFileUrl, resourceName);
                ResourceEntry entry = new ResourceEntry(jarEntryUrl, content);
                this.addResourceEntry(resourceName, entry);
                this.addResourceEntryForClass(resourceName, entry);
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
        }
    }

    private static URL buildJarEntryUrl(URL jarFileUrl, String entryName) throws MalformedURLException {
        StringBuffer result = new StringBuffer("jar:");
        result.append(jarFileUrl);
        result.append("!/");
        result.append(entryName);
        return new URL(result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readContent(File file) throws Exception {
        int size = (int)file.length();
        byte[] buffer = new byte[size];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 4096);
        try {
            for (int pos = 0; pos < size; pos += in.read(buffer, pos, size - pos)) {
            }
        }
        finally {
            in.close();
        }
        return buffer;
    }

    protected void log(String logLevel, String msg, Exception e) {
        if (this.isLogEnabled(logLevel)) {
            this.writeLog(logLevel, "(" + this.configuration.getName() + ") - " + msg, e);
        }
    }

    protected void log(String logLevel, String msg, String arg, Exception e) {
        if (this.isLogEnabled(logLevel)) {
            msg = MsgFormat.format(msg, arg);
            this.writeLog(logLevel, "(" + this.configuration.getName() + ") - " + msg, e);
        }
    }

    protected void log(String logLevel, String msg, String arg) {
        if (this.isLogEnabled(logLevel)) {
            msg = MsgFormat.format(msg, arg);
            this.writeLog(logLevel, "(" + this.configuration.getName() + ") - " + msg, null);
        }
    }

    protected void log(String logLevel, String msg, String arg, String arg2) {
        if (this.isLogEnabled(logLevel)) {
            msg = MsgFormat.format(msg, arg, arg2);
            this.writeLog(logLevel, "(" + this.configuration.getName() + ") - " + msg, null);
        }
    }

    protected void log(String logLevel, String msg) {
        if (this.isLogEnabled(logLevel)) {
            this.writeLog(logLevel, "(" + this.configuration.getName() + ") - " + msg, null);
        }
    }

    protected abstract void setupLogger();

    protected abstract void writeLog(String var1, String var2, Exception var3);

    protected abstract boolean isLogEnabled(String var1);

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append(" (");
        buf.append(this.configuration.getName());
        buf.append(") : ");
        buf.append(super.toString());
        return buf.toString();
    }
}

