/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.commandline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openbp.common.CollectionUtil;
import org.openbp.common.application.Application;
import org.openbp.common.commandline.CommandLineParserException;

public class CommandLineParser {
    private Map options = new HashMap();
    private List arguments = new ArrayList();
    private Map possibleOptions = new HashMap();
    private List possibleOptionList = new ArrayList();
    private String[] usageMsgHeader;
    private int maxOptionNameLength = 5;
    private boolean acceptUnknownOptions;

    public void addBooleanOption(String name, String usageMsg) {
        this.addOption(name, false, false, usageMsg, null);
    }

    public void addBooleanOption(String name, String usageMsg, boolean dflt) {
        this.addOption(name, false, false, usageMsg, new Boolean(dflt));
    }

    public void addArgumentOption(String name, String usageMsg) {
        this.addOption(name, true, false, usageMsg, null);
    }

    public void addArgumentOption(String name, String usageMsg, String dflt) {
        this.addOption(name, true, false, usageMsg, dflt);
    }

    public void addRepeatableOption(String name, String usageMsg) {
        this.addOption(name, true, true, usageMsg, null);
    }

    private void addOption(String name, boolean requiresArgument, boolean repeatable, String usageMsg, Object dflt) {
        int l = name.length();
        if (l > this.maxOptionNameLength) {
            this.maxOptionNameLength = l;
        }
        Option option = new Option(name, requiresArgument, repeatable, usageMsg);
        this.possibleOptions.put(name.toLowerCase(), option);
        this.possibleOptionList.add(option);
        if (dflt != null) {
            this.options.put(name, dflt);
        }
    }

    public void setAcceptUnknownOptions(boolean acceptUnknownOptions) {
        this.acceptUnknownOptions = acceptUnknownOptions;
    }

    public void setUsageMsgHeader(String[] usageMsgHeader) {
        this.usageMsgHeader = usageMsgHeader;
    }

    public void parse(String[] args) throws CommandLineParserException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            char c = arg.charAt(0);
            if (c == '-' || c == '+') {
                String option = arg.substring(1);
                Option opt = (Option)this.possibleOptions.get((option = option.toLowerCase()).toLowerCase());
                if (opt != null) {
                    if (opt.requiresArgument) {
                        if (i == args.length - 1) {
                            throw new CommandLineParserException("Option " + option + " requires an argument");
                        }
                        String optArg = args[++i];
                        if (opt.repeatable) {
                            ArrayList<String> list = (ArrayList<String>)this.options.get(option);
                            if (list == null) {
                                list = new ArrayList<String>();
                                this.options.put(option, list);
                            }
                            list.add(optArg);
                            continue;
                        }
                        this.options.put(option, optArg);
                        continue;
                    }
                    this.options.put(option, new Boolean(c != '-'));
                    continue;
                }
                if (this.acceptUnknownOptions) continue;
                throw new CommandLineParserException("Invalid Option: " + option);
            }
            this.arguments.add(arg);
        }
    }

    public void printUsageAndExit() {
        this.printUsage();
        System.exit(1);
    }

    public void printUsage() {
        if (this.usageMsgHeader != null) {
            for (int i = 0; i < this.usageMsgHeader.length; ++i) {
                System.err.println(this.usageMsgHeader[i]);
            }
        } else {
            System.err.print("Usage: ");
            if (Application.getAppName() != null) {
                System.err.print(Application.getAppName());
            }
            System.err.println();
        }
        StringBuffer sb = new StringBuffer();
        int l = this.possibleOptionList.size();
        for (int i = 0; i < l; ++i) {
            sb.setLength(0);
            Option option = (Option)this.possibleOptionList.get(i);
            sb.append(option.requiresArgument ? "-" : "+/-");
            sb.append(option.name);
            if (option.requiresArgument) {
                sb.append(" <arg>");
            }
            if (option.repeatable) {
                sb.append(" ...");
            }
            this.fillBuf(sb, this.maxOptionNameLength + 12);
            System.err.print(sb.toString());
            System.err.println(option.usageMsg);
        }
    }

    private void fillBuf(StringBuffer sb, int l) {
        int n = l - sb.length();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
    }

    public Iterator getOptions() {
        return this.options.keySet().iterator();
    }

    public String getStringOption(String name) throws CommandLineParserException {
        Object o = this.options.get(name.toLowerCase());
        if (o != null && !(o instanceof String)) {
            throw new CommandLineParserException("Option is not a string option: " + name);
        }
        return (String)o;
    }

    public String[] getRepeatableOption(String name) throws CommandLineParserException {
        Object o = this.options.get(name.toLowerCase());
        if (o != null) {
            if (!(o instanceof List)) {
                throw new CommandLineParserException("Option is not a repeatable string option: " + name);
            }
            return CollectionUtil.toStringArray((List)o);
        }
        return null;
    }

    public boolean getBooleanOption(String name, boolean dflt) throws CommandLineParserException {
        Object o = this.options.get(name.toLowerCase());
        if (o != null) {
            if (!(o instanceof Boolean)) {
                throw new CommandLineParserException("Option is not a boolean option: " + name);
            }
            return (Boolean)o;
        }
        return dflt;
    }

    public boolean getBooleanOption(String name) throws CommandLineParserException {
        return this.getBooleanOption(name, false);
    }

    public String[] getArguments() {
        return CollectionUtil.toStringArray(this.arguments);
    }

    private class Option {
        public String name;
        public boolean requiresArgument;
        public boolean repeatable;
        public String usageMsg;

        public Option(String name, boolean requiresArgument, boolean repeatable, String usageMsg) {
            this.name = name;
            this.requiresArgument = requiresArgument;
            this.repeatable = repeatable;
            this.usageMsg = usageMsg;
        }
    }
}

