/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.generic.description;

import org.openbp.common.CommonUtil;
import org.openbp.common.generic.Copyable;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.generic.description.Validatable;
import org.openbp.common.generic.msgcontainer.MsgContainer;
import org.openbp.common.string.TextUtil;
import org.openbp.common.util.ToStringHelper;

public class DescriptionObjectImpl
implements DescriptionObject,
Cloneable,
Copyable,
Validatable {
    private String name;
    private String description;

    public DescriptionObjectImpl() {
    }

    public DescriptionObjectImpl(String name) {
        this.name = name;
    }

    public DescriptionObjectImpl(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DescriptionObjectImpl clone = (DescriptionObjectImpl)super.clone();
        clone.copyFrom(this, 2);
        return clone;
    }

    @Override
    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        DescriptionObjectImpl src = (DescriptionObjectImpl)source;
        this.name = src.name;
        this.description = src.description;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, "name");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionEscape() {
        return TextUtil.encodeMultiLineString(this.description);
    }

    public void setDescriptionEscape(String description) {
        this.description = TextUtil.decodeMultiLineString(description);
    }

    @Override
    public String getDescriptionText() {
        return this.getDescription();
    }

    @Override
    public String getDisplayText() {
        return this.getName();
    }

    public int compareTo(Object o) {
        String n1 = this.getName();
        String n2 = ((DescriptionObject)o).getName();
        return CommonUtil.compareNull(n1, n2);
    }

    @Override
    public boolean validate(MsgContainer msgContainer) {
        if (this.getName() == null) {
            msgContainer.addMsg(this, "No object name specified");
            return false;
        }
        return true;
    }
}

