/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.generic.msgcontainer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.MsgFormat;
import org.openbp.common.generic.PrintNameProvider;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.logger.LogUtil;

public class MsgItem
implements Serializable {
    private transient Object source;
    private String msgType;
    private String msg;
    private Object[] msgArgs;

    public MsgItem() {
    }

    public MsgItem(String msgType, Object source, String msg, Object[] msgArgs) {
        this.msgType = msgType;
        this.source = source;
        this.msg = msg;
        this.msgArgs = msgArgs;
    }

    public String toString() {
        return this.getFormattedMsgWithSource();
    }

    public String getSourceString() {
        String ret = null;
        if (this.source != null) {
            if (this.source instanceof PrintNameProvider) {
                ret = ((PrintNameProvider)this.source).getPrintName();
            }
            if (ret == null && this.source instanceof DescriptionObject) {
                ret = ((DescriptionObject)this.source).getName();
            }
            if (ret == null) {
                ret = this.source.toString();
            }
        }
        return ret;
    }

    public String getFormattedMsgWithSource() {
        String ret = this.getSourceString();
        String msg = this.getFormattedMsg();
        if (msg != null) {
            ret = ret != null ? ret + ": " + msg : msg;
        }
        return ret;
    }

    public String getFormattedMsg() {
        String s = !this.msgType.equals("Error") ? this.msgType + ": " + this.msg : this.msg;
        if (s != null && this.msgArgs != null) {
            try {
                Throwable throwable;
                String exceptionMsg;
                Object o;
                int l = this.msgArgs.length;
                for (int i = 0; i < l; ++i) {
                    if (this.msgArgs[i] != null) continue;
                    this.msgArgs[i] = "(null)";
                }
                if (this.msgArgs != null) {
                    s = MsgFormat.format(s, this.msgArgs);
                }
                if ((o = this.msgArgs[l - 1]) instanceof Throwable && (exceptionMsg = ExceptionUtil.getNestedMessage(throwable = (Throwable)o)) != null) {
                    s = s + ": ";
                    s = s + exceptionMsg;
                }
            }
            catch (Exception e) {
                LogUtil.error(this.getClass(), "Logging error: Can't format message $0 with {1} arguments.", s, new Integer(this.msgArgs.length), e);
            }
        }
        return s;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getSourceString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.source = in.readObject();
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object[] getMsgArgs() {
        return this.msgArgs;
    }

    public void setMsgArgs(Object[] msgArgs) {
        this.msgArgs = msgArgs;
    }
}

