/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.generic.propertybrowser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.generic.propertybrowser.PropertyDescriptor;
import org.openbp.common.util.CopyUtil;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.common.util.iterator.EmptyIterator;

public class ObjectDescriptor
extends DisplayObjectImpl {
    private String objectClassName;
    private String validatorClassName;
    private List propertyList;
    private Class objectClass;
    private Class validatorClass;
    private boolean customDescriptor;
    private boolean propertiesResolved;

    @Override
    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        super.copyFrom(source, copyMode);
        ObjectDescriptor src = (ObjectDescriptor)source;
        this.objectClassName = src.objectClassName;
        this.validatorClassName = src.validatorClassName;
        this.objectClass = src.objectClass;
        this.validatorClass = src.validatorClass;
        this.propertyList = copyMode == 1 || copyMode == 2 ? (List)CopyUtil.copyCollection(src.propertyList, copyMode == 2 ? 2 : 0) : src.propertyList;
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    public String getValidatorClassName() {
        return this.validatorClassName;
    }

    public void setValidatorClassName(String validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    public Class getValidatorClass() {
        return this.validatorClass;
    }

    public void setValidatorClass(Class validatorClass) {
        this.validatorClass = validatorClass;
    }

    public PropertyDescriptor getProperty(String name) {
        if (this.propertyList != null) {
            return (PropertyDescriptor)NamedObjectCollectionUtil.getByName(this.propertyList, name);
        }
        return null;
    }

    public Iterator getProperties() {
        if (this.propertyList == null) {
            return EmptyIterator.getInstance();
        }
        return this.propertyList.iterator();
    }

    public void addProperty(PropertyDescriptor property) {
        if (this.propertyList == null) {
            this.propertyList = new ArrayList();
        }
        this.propertyList.add(property);
    }

    public void clearProperties() {
        this.propertyList = null;
    }

    public List getPropertyList() {
        return this.propertyList;
    }

    public boolean isCustomDescriptor() {
        return this.customDescriptor;
    }

    public void setCustomDescriptor(boolean customDescriptor) {
        this.customDescriptor = customDescriptor;
    }

    public boolean isPropertiesResolved() {
        return this.propertiesResolved;
    }

    public void setPropertiesResolved(boolean propertiesResolved) {
        this.propertiesResolved = propertiesResolved;
    }
}

