/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.string.StringUtil;
import org.openbp.common.string.shellmatcher.ShellMatcher;

public final class FileUtil {
    public static final int FILETYPE_ANY = 0;
    public static final int FILETYPE_FILE = 1;
    public static final int FILETYPE_DIR = 2;

    private FileUtil() {
    }

    public static String[] list(String dirName, String pattern, int fileType) {
        PatternFilenameFilter pff = null;
        if (pattern != null || fileType != 0) {
            pff = new PatternFilenameFilter(pattern, fileType);
        }
        File dir = new File(dirName);
        String[] fileNames = dir.list(pff);
        return fileNames;
    }

    public static void remove(File src) throws IOException {
        if (src.isFile()) {
            if (!src.delete()) {
                throw new IOException("Can't delete file '" + src.getPath() + "'");
            }
        } else {
            String[] files = src.list();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                FileUtil.remove(new File(src, files[i]));
            }
            if (!src.delete()) {
                throw new IOException("Can't delete directory '" + src.getPath() + "'");
            }
        }
    }

    public static void copy(File src, File dest) throws IOException {
        FileUtil.copy(src, dest, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest, FilenameFilter filter) throws IOException {
        block45: {
            if (!src.exists()) {
                throw new IOException("Source file not found: " + src);
            }
            if (!src.canRead()) {
                throw new IOException("Source file is unreadable: " + src);
            }
            if (src.isFile()) {
                if (!dest.exists()) {
                    File parentdir = FileUtil.getParent(dest, false);
                    if (parentdir != null && !parentdir.exists()) {
                        parentdir.mkdirs();
                    }
                } else if (dest.isDirectory()) {
                    dest = new File(dest + "/" + FileUtil.getBaseNameWithExtension(src));
                }
            } else if (src.isDirectory()) {
                if (dest.isFile()) {
                    throw new IOException("Cannot copy directory " + src + " to file " + dest);
                }
                if (!dest.exists()) {
                    dest.mkdirs();
                }
            }
            if (src.isFile()) {
                FileInputStream source = null;
                FileOutputStream destination = null;
                try {
                    source = new FileInputStream(src);
                    destination = new FileOutputStream(dest);
                    byte[] buffer = new byte[1024];
                    while (true) {
                        int bytesRead;
                        if ((bytesRead = source.read(buffer)) == -1) {
                            break block45;
                        }
                        destination.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (IOException e) {}
                    }
                    if (destination != null) {
                        try {
                            destination.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            if (src.isDirectory()) {
                String[] files = src.list(filter);
                block23: for (int i = 0; i < files.length; ++i) {
                    String member = files[i];
                    String srcMember = StringUtil.buildPath(src.getPath(), member);
                    String destMember = StringUtil.buildPath(dest.getPath(), member);
                    if (new File(srcMember).isDirectory()) {
                        FileUtil.copy(new File(srcMember), new File(destMember), filter);
                        continue;
                    }
                    FileInputStream source = null;
                    FileOutputStream destination = null;
                    try {
                        source = new FileInputStream(srcMember);
                        destination = new FileOutputStream(destMember);
                        byte[] buffer = new byte[1024];
                        while (true) {
                            int bytesRead;
                            if ((bytesRead = source.read(buffer)) == -1) {
                                continue block23;
                            }
                            destination.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (IOException e) {}
                        }
                        if (destination != null) {
                            try {
                                destination.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
        }
    }

    public static boolean deleteFile(File f, FilenameFilter filter) {
        if (f == null) {
            return false;
        }
        boolean success = true;
        if (f.isFile()) {
            f.delete();
        } else if (f.isDirectory()) {
            File[] files = f.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                if (FileUtil.deleteFile(files[i], filter)) continue;
                success = false;
            }
            if (success) {
                f.delete();
            }
        }
        return success;
    }

    public static String getBaseNameWithExtension(File file) {
        return FileUtil.getBaseNameWithExtension(file.toString());
    }

    public static String getBaseNameWithExtension(String pathName) {
        int iSep = pathName.lastIndexOf(47);
        return iSep >= 0 ? pathName.substring(iSep + 1) : pathName;
    }

    public static String getBaseName(String pathName) {
        int iSep = pathName.lastIndexOf(47);
        int iDot = pathName.lastIndexOf(46);
        if (iSep >= 0) {
            if (iDot > iSep) {
                return pathName.substring(iSep + 1, iDot);
            }
            return pathName.substring(iSep + 1);
        }
        if (iDot > 0) {
            return pathName.substring(0, iDot);
        }
        return pathName;
    }

    public static String getDirectoryFromFilePath(String filePath) {
        int i = (filePath = StringUtil.normalizePathName(filePath)).lastIndexOf(47);
        return i > 0 ? filePath.substring(0, i) : null;
    }

    public static String getRelativePathToParentDir(String target, String origin) {
        if (origin == null) {
            return target;
        }
        origin = StringUtil.absolutePathName(origin);
        target = StringUtil.absolutePathName(target);
        if (!origin.endsWith("/")) {
            origin = origin + "/";
        }
        String retVal = null;
        if (target.startsWith(origin)) {
            int start = origin.length();
            int end = target.length();
            retVal = target.substring(start, end);
        }
        return retVal;
    }

    public static String getRelativePath(String startPath, String targetPath) {
        int i;
        int common;
        if (startPath == null || targetPath == null) {
            throw new IllegalArgumentException("Null not allowed.");
        }
        startPath = StringUtil.absolutePathName(startPath);
        targetPath = StringUtil.absolutePathName(targetPath);
        File startDir = new File(startPath);
        File targetDir = new File(targetPath);
        if (!startDir.isAbsolute() || !targetDir.isAbsolute()) {
            throw new IllegalArgumentException("Relative pathes not allowed.");
        }
        String[] startPathTokens = StringUtil.tokenize(startPath, "/");
        String[] targetPathTokens = StringUtil.tokenize(targetPath, "/");
        File[] roots = File.listRoots();
        if (roots[0].getPath() != "/" && !startPathTokens[0].equalsIgnoreCase(targetPathTokens[0])) {
            throw new IllegalArgumentException("Files reside in different roots.");
        }
        for (int i2 = common = roots[0].getPath() != "/" ? 1 : 0; i2 < Math.min(startPathTokens.length, targetPathTokens.length) && startPathTokens[i2].equals(targetPathTokens[i2]); ++i2) {
            ++common;
        }
        StringBuffer result = new StringBuffer();
        for (i = common; i < startPathTokens.length; ++i) {
            if (result.length() > 0) {
                result.append("/");
            }
            result.append("..");
        }
        for (i = common; i < targetPathTokens.length; ++i) {
            if (result.length() > 0) {
                result.append("/");
            }
            result.append(targetPathTokens[i]);
        }
        return result.toString();
    }

    public static String constructFileName(String dir, String name, String extension) {
        StringBuffer sb = new StringBuffer();
        if (dir != null) {
            sb.append(dir);
            sb.append('/');
        }
        sb.append(name);
        if (extension != null && !name.endsWith(extension)) {
            sb.append(extension);
        }
        return sb.toString();
    }

    public static File createTempFile(String directory, String prefix, String suffix, String extension) {
        File retFile = null;
        if (directory == null) {
            directory = "";
        } else if (!directory.endsWith("/") && !directory.endsWith("\\")) {
            directory = directory + "/";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        if (extension == null) {
            extension = "";
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        int i = 0;
        while ((retFile = new File(directory + prefix + i + suffix + "." + extension)).exists()) {
            ++i;
        }
        return retFile;
    }

    public static File getParent(File f, boolean returnCurrent) {
        try {
            String dirname = f.getParent();
            if (dirname != null) {
                return new File(dirname);
            }
            if (f.isAbsolute()) {
                return new File("/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnCurrent ? new File(System.getProperty("user.dir")) : null;
    }

    public static void main(String[] args) {
        try {
            FileUtil.remove(new File("D://temp//test"));
        }
        catch (IOException e) {
            ExceptionUtil.printTrace(e);
        }
    }

    static class PatternFilenameFilter
    implements FilenameFilter {
        private ShellMatcher sm = null;
        private int fileType;

        public PatternFilenameFilter(String pattern, int fileType) {
            if (pattern != null) {
                this.sm = new ShellMatcher(pattern);
                this.sm.setIgnoreCase(true);
            }
            this.fileType = fileType;
        }

        @Override
        public boolean accept(File dir, String name) {
            File f;
            if (this.sm != null && !this.sm.match(name)) {
                return false;
            }
            return this.fileType == 0 || !((f = new File(StringUtil.buildPath(dir.getPath(), name))).isDirectory() ? this.fileType == 1 : this.fileType == 2);
        }
    }
}

