/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.openbp.common.io.FileUtil;
import org.openbp.common.io.RetryNotifier;

public final class IOUtil {
    public static final String CHAR_SET_UTF_8 = "UTF-8";
    public static final String CHAR_SET_ISO_8859_1 = "ISO-8859-1";

    private IOUtil() {
    }

    public static String readTextFile(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(line);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String inputFileName) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inputFileName);
            String string = IOUtil.readTextFile(in);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File inputFile) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inputFile);
            String string = IOUtil.readTextFile(in);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean writeFile(String outputFileName, String outString, RetryNotifier rn) throws IOException {
        return IOUtil.writeFile(outputFileName, outString, null, rn, null);
    }

    public static boolean writeFile(String outputFileName, String outString, RetryNotifier rn, boolean append) throws IOException {
        return IOUtil.writeFile(outputFileName, outString, null, rn, null, append);
    }

    public static boolean writeFile(String outputFileName, String outString, RetryNotifier rn, String charSet) throws IOException {
        return IOUtil.writeFile(outputFileName, outString, null, rn, charSet);
    }

    public static boolean writeFile(String outputFileName, String outString, RetryNotifier rn, String charSet, boolean append) throws IOException {
        return IOUtil.writeFile(outputFileName, outString, null, rn, charSet, append);
    }

    public static boolean writeFile(String outputFileName, byte[] outBytes, RetryNotifier rn) throws IOException {
        return IOUtil.writeFile(outputFileName, null, outBytes, rn, null);
    }

    public static boolean writeFile(String outputFileName, byte[] outBytes, RetryNotifier rn, boolean append) throws IOException {
        return IOUtil.writeFile(outputFileName, null, outBytes, rn, null, append);
    }

    public static boolean writeFile(String outputFileName, byte[] outBytes, RetryNotifier rn, String charSet) throws IOException {
        return IOUtil.writeFile(outputFileName, null, outBytes, rn, charSet);
    }

    public static boolean writeFile(String outputFileName, byte[] outBytes, RetryNotifier rn, String charSet, boolean append) throws IOException {
        return IOUtil.writeFile(outputFileName, null, outBytes, rn, null, append);
    }

    private static boolean writeFile(String outputFileName, String outString, byte[] outBytes, RetryNotifier rn, String charSet) throws IOException {
        return IOUtil.writeFile(outputFileName, outString, outBytes, rn, charSet, false);
    }

    private static boolean writeFile(String outputFileName, String outString, byte[] outBytes, RetryNotifier rn, String charSet, boolean append) throws IOException {
        FileOutputStream stream = null;
        while (true) {
            try {
                File f = new File(outputFileName);
                File parentdir = FileUtil.getParent(f, false);
                if (parentdir != null && !parentdir.exists()) {
                    parentdir.mkdirs();
                }
                stream = new FileOutputStream(outputFileName, append);
                if (outString != null) {
                    if (charSet == null) {
                        charSet = CHAR_SET_UTF_8;
                    }
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charSet);
                    writer.write(outString);
                    writer.close();
                } else if (outBytes != null) {
                    stream.write(outBytes);
                }
                stream.flush();
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                if (rn != null) {
                    if (rn.shallRetry(e, outputFileName)) continue;
                    boolean bl = false;
                    return bl;
                }
                throw e;
            }
            finally {
                if (stream == null) continue;
                stream.close();
                continue;
            }
            break;
        }
    }
}

