/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.rc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.markup.XMLUtil;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.common.rc.ResourceItem;
import org.openbp.common.rc.ResourceItemTypes;
import org.openbp.common.rc.text.TPlain;
import org.openbp.common.string.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceCollection {
    protected static final String RESOURCE_EXTENSION = ".xml";
    public static final String TAG_RESOURCE = "resource";
    public static final String ATTRIBUTE_PRELOAD = "preload";
    public static final String TAG_RESOURCE_ITEM = "item";
    public static final String TAG_IMPORT = "import";
    public static final String ATTRIBUTE_IMPORT_RESOURCE = "resource";
    public static final String ATTRIBUTE_IMPORT_CONTAINER = "container";
    public static final String TAG_GROUP = "group";
    public static final String ATTRIBUTE_GROUP_NAME = "name";
    private String resourcePath;
    private String resourceName;
    protected String containerName;
    private Locale locale;
    protected ResourceCollection parentResourceCollection;
    private ResourceCollectionMgr resourceCollectionMgr;
    private Map resourceItems;
    private ArrayList resourceImports;

    public ResourceCollection(String containerName, String resourceName, Locale locale, ResourceCollectionMgr resourceCollectionMgr, InputStream stream) throws IOException, SAXException {
        this.containerName = containerName;
        this.resourceName = resourceName;
        this.locale = locale;
        this.resourceCollectionMgr = resourceCollectionMgr;
        resourceName = StringUtil.normalizeDir(resourceName);
        String s = ResourceCollectionMgr.constructResourceCollectionLocalPath(containerName, locale, resourceName);
        int i = s.lastIndexOf(47);
        this.resourcePath = s.substring(0, i);
        resourceName = s.substring(i + 1);
        this.resourceItems = new HashMap();
        this.readFromInput(stream);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getName() {
        return this.resourceName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceCollection getParentResource() {
        return this.parentResourceCollection;
    }

    public void setParentResource(ResourceCollection parentResourceCollection) {
        this.parentResourceCollection = parentResourceCollection;
    }

    public ResourceCollectionMgr getResourceCollectionMgr() {
        return this.resourceCollectionMgr;
    }

    public String getRequiredString(String resourceItemName) {
        Object o = this.getRequiredObject(resourceItemName);
        if (o != null) {
            return this.performVariableReplacement(o);
        }
        return resourceItemName;
    }

    public Object getRequiredObject(String resourceItemName) {
        Object obj = this.getResourceObject(resourceItemName);
        if (obj == null) {
            if (this.parentResourceCollection != null) {
                obj = this.parentResourceCollection.getOptionalObject(resourceItemName);
            }
            if (obj == null) {
                LogUtil.error(this.getClass(), "Resource $0: Cannot find resource item $1.", this.getErrorName(), resourceItemName);
            }
        }
        return obj;
    }

    public String getOptionalString(String resourceItemName) {
        Object o = this.getOptionalObject(resourceItemName);
        if (o != null) {
            return this.performVariableReplacement(o);
        }
        return null;
    }

    public String getOptionalString(String resourceItemName, String dflt) {
        Object o = this.getOptionalObject(resourceItemName);
        if (o != null) {
            return this.performVariableReplacement(o);
        }
        return dflt;
    }

    private String performVariableReplacement(Object o) {
        String result = o.toString();
        result = this.getResourceCollectionMgr().performVariableReplacement(result);
        return result;
    }

    public Object getOptionalObject(String resourceItemName) {
        Object obj = this.getResourceObject(resourceItemName);
        if (obj == null && this.parentResourceCollection != null && this.parentResourceCollection != this) {
            obj = this.parentResourceCollection.getOptionalObject(resourceItemName);
        }
        return obj;
    }

    public Object getOptionalObject(String resourceItemName, Object dflt) {
        Object obj = this.getResourceObject(resourceItemName);
        if (obj == null) {
            if (this.parentResourceCollection != null) {
                obj = this.parentResourceCollection.getOptionalObject(resourceItemName);
            }
            if (obj == null) {
                obj = dflt;
            }
        }
        return obj;
    }

    public void addResourceItem(ResourceItem item) {
        this.resourceItems.put(item.getName(), item);
    }

    public void addImport(ResourceCollection importedResourceCollection) {
        if (this.resourceImports == null) {
            this.resourceImports = new ArrayList();
        }
        if (!this.resourceImports.contains(importedResourceCollection)) {
            this.resourceImports.add(importedResourceCollection);
        }
    }

    public Iterator getKeys() {
        HashMap<Object, Boolean> retVal = new HashMap<Object, Boolean>();
        if (this.parentResourceCollection != null) {
            Iterator parentKeys = this.parentResourceCollection.getKeys();
            while (parentKeys.hasNext()) {
                retVal.put(parentKeys.next(), Boolean.TRUE);
            }
        }
        Iterator keys = this.resourceItems.keySet().iterator();
        while (keys.hasNext()) {
            retVal.put(keys.next(), Boolean.TRUE);
        }
        if (this.resourceImports != null) {
            for (ResourceCollection res : this.resourceImports) {
                Iterator keys2 = res.getKeys();
                while (keys2.hasNext()) {
                    retVal.put(keys2.next(), Boolean.TRUE);
                }
            }
        }
        return retVal.keySet().iterator();
    }

    public ResourceItem getResourceItem(String resourceItemName) {
        ResourceItem item;
        Object o = this.resourceItems.get(resourceItemName);
        if (o instanceof ResourceItem) {
            return (ResourceItem)o;
        }
        if (o == Boolean.FALSE) {
            return null;
        }
        if (this.resourceImports != null) {
            for (ResourceCollection importedResourceCollection : this.resourceImports) {
                ResourceItem item2 = importedResourceCollection.getResourceItem(resourceItemName);
                if (item2 == null) continue;
                this.addResourceItem(item2);
                return item2;
            }
        }
        if (this.parentResourceCollection != null && this.parentResourceCollection != this && (item = this.parentResourceCollection.getResourceItem(resourceItemName)) != null) {
            return item;
        }
        this.resourceItems.put(resourceItemName, Boolean.FALSE);
        return null;
    }

    public String getErrorName() {
        return this.getResourcePath() + "/" + this.getName();
    }

    protected Object getResourceObject(String resourceItemName) {
        ResourceItem resourceItem = this.getResourceItem(resourceItemName);
        if (resourceItem != null) {
            return resourceItem.getObject();
        }
        return null;
    }

    protected void readFromInput(InputStream stream) throws IOException, SAXException {
        InputSource source = new InputSource(stream);
        Document doc = XMLUtil.parseDocument(source);
        Element root = doc.getDocumentElement();
        boolean preload = Boolean.getBoolean(root.getAttribute(ATTRIBUTE_PRELOAD));
        this.parseResource(root, null, preload);
    }

    protected void parseResource(Element parentNode, String groupPath, boolean preload) {
        NodeList items = parentNode.getChildNodes();
        int nItems = items.getLength();
        for (int i = 0; i < nItems; ++i) {
            if (!(items.item(i) instanceof Element)) continue;
            Element child = (Element)items.item(i);
            String tagName = child.getTagName();
            if (tagName.equals(TAG_RESOURCE_ITEM)) {
                ResourceItem item = this.createResourceItem(child, groupPath, preload);
                if (item == null) continue;
                this.addResourceItem(item);
                continue;
            }
            if (tagName.equals(TAG_GROUP)) {
                String groupName = child.getAttribute(ATTRIBUTE_GROUP_NAME);
                String path = groupPath == null ? groupName : groupPath + "." + groupName;
                this.parseResource(child, path, preload);
                continue;
            }
            if (tagName.equals(TAG_IMPORT)) {
                String importResourceName = child.getAttribute("resource");
                String importPBContainerName = child.getAttribute(ATTRIBUTE_IMPORT_CONTAINER);
                ResourceCollection importedResourceCollection = null;
                if (importPBContainerName != null) {
                    importPBContainerName = importPBContainerName.trim();
                }
                if (importPBContainerName == null || importPBContainerName.length() == 0) {
                    importPBContainerName = this.getContainerName();
                }
                if ((importedResourceCollection = this.getResourceCollectionMgr().getResource(importPBContainerName, importResourceName, this.locale)) == null) continue;
                this.addImport(importedResourceCollection);
                continue;
            }
            LogUtil.error(this.getClass(), "Resource $0: Unexpected resource type $1.", this.getErrorName(), tagName);
        }
    }

    protected ResourceItem createResourceItem(Element resourceItemNode, String group, boolean preload) {
        String mimeType = resourceItemNode.getAttribute("type");
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = "text/plain";
        }
        ResourceItem resourceItem = null;
        try {
            if (mimeType.equals("text/plain")) {
                resourceItem = new TPlain();
            } else {
                Class resourceItemClass = ResourceItemTypes.determineResourceItemClass(mimeType);
                if (resourceItemClass == null) {
                    LogUtil.error(this.getClass(), "Resource $0: Unsupported resource mime type $1.", this.getErrorName(), mimeType);
                    return null;
                }
                resourceItem = (ResourceItem)resourceItemClass.newInstance();
            }
            resourceItem.initializeFromDOM(this, resourceItemNode, group);
            if (preload) {
                resourceItem.getObject();
            }
        }
        catch (IllegalAccessException e) {
            LogUtil.error(this.getClass(), "Resource $0: Access failed to the resource class for mime type $1.", this.getErrorName(), mimeType);
            return null;
        }
        catch (InstantiationException e) {
            LogUtil.error(this.getClass(), "Resource $0: Cannot instantiate resource class for mime type $1.", this.getErrorName(), mimeType);
            return null;
        }
        return resourceItem;
    }

    public byte[] readResourceItem(String relativePath) {
        String path = this.getResourceItemPath(relativePath);
        byte[] data = this.getResourceCollectionMgr().getResourceMgr().loadByteResource(path);
        return data;
    }

    public String getResourceItemPath(String relativePath) {
        String path = this.getResourcePath() + "/" + relativePath;
        path = StringUtil.normalizePathName(path);
        return path;
    }
}

