/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.registry;

import java.util.Map;
import org.openbp.common.MsgFormat;
import org.openbp.common.ReflectException;
import org.openbp.common.ReflectUtil;
import org.openbp.common.registry.MappingRegistry;

public class ClassMappingRegistry {
    private MappingRegistry registry = new MappingRegistry();

    public Class getMappedClass(Class cls) {
        Class ret = (Class)this.registry.lookup(cls);
        if (ret == null) {
            ret = cls;
        }
        return ret;
    }

    public void addShallowMapping(Class from, Class to) {
        this.registry.register(from.getName(), to);
    }

    public void addDeepMapping(Class from, Class to) {
        this.registry.registerByClass(from, to);
    }

    public void addShallowMapping(String fromName, String toName) {
        Class to = ReflectUtil.loadClass(toName);
        if (to == null) {
            throw new ReflectException(MsgFormat.format("Result class $0 for class mapping not found.", toName));
        }
        this.registry.register(fromName, to);
    }

    public void addDeepMapping(String fromName, String toName) {
        Class from = ReflectUtil.loadClass(fromName);
        if (from == null) {
            throw new ReflectException(MsgFormat.format("Mapped class $0 for class mapping not found.", fromName));
        }
        Class to = ReflectUtil.loadClass(toName);
        if (to == null) {
            throw new ReflectException(MsgFormat.format("Result class $0 for class mapping not found.", toName));
        }
        this.registry.registerByClass(from, to);
    }

    public void setShallowMapppings(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.addShallowMapping((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

