/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.setting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.setting.ProviderInfo;
import org.openbp.common.setting.SettingProvider;
import org.openbp.common.util.ToStringHelper;

public class SettingResolver
implements Cloneable {
    public static final char PROVIDER_SEPARATOR = ':';
    private List providerInfoList = new ArrayList();

    public Object clone() throws CloneNotSupportedException {
        SettingResolver clone = (SettingResolver)super.clone();
        clone.providerInfoList = new ArrayList();
        for (ProviderInfo pi : this.providerInfoList) {
            clone.providerInfoList.add(pi);
        }
        return clone;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, new String[]{"providerInfoList"});
    }

    public Object getSetting(String name, Object dflt) {
        if (name == null) {
            return dflt;
        }
        Object value = null;
        int index = name.indexOf(58);
        if (index > 0) {
            String providerName = name.substring(0, index);
            name = name.substring(index + 1);
            SettingProvider provider = this.getProvider(providerName);
            if (provider != null) {
                value = provider.getSetting(name);
            }
        } else {
            ProviderInfo pi;
            int n = this.providerInfoList.size();
            for (int i = 0; i < n && (value = (pi = (ProviderInfo)this.providerInfoList.get(i)).getProvider().getSetting(name)) == null; ++i) {
            }
        }
        if (value == null) {
            value = dflt;
        }
        return value;
    }

    public SettingProvider setSetting(String name, Object value) {
        int index;
        if (name == null) {
            return null;
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        if ((index = name.indexOf(58)) > 0) {
            String providerName = name.substring(0, index);
            name = name.substring(index + 1);
            SettingProvider provider = this.getProvider(providerName);
            if (provider != null && provider.setSetting(name, value)) {
                return provider;
            }
        } else {
            int n = this.providerInfoList.size();
            for (int i = 0; i < n; ++i) {
                ProviderInfo pi = (ProviderInfo)this.providerInfoList.get(i);
                if (!pi.getProvider().setSetting(name, value)) continue;
                return pi.getProvider();
            }
        }
        return null;
    }

    public boolean loadSettings(String providerName) {
        boolean ret = true;
        int n = this.providerInfoList.size();
        for (int i = 0; i < n; ++i) {
            ProviderInfo pi = (ProviderInfo)this.providerInfoList.get(i);
            if (providerName != null && !pi.getName().equals(providerName) || pi.getProvider().loadSettings()) continue;
            ret = false;
        }
        return ret;
    }

    public boolean saveSettings(String providerName) {
        boolean ret = true;
        int n = this.providerInfoList.size();
        for (int i = 0; i < n; ++i) {
            ProviderInfo pi = (ProviderInfo)this.providerInfoList.get(i);
            if (providerName != null && !pi.getName().equals(providerName) || pi.getProvider().saveSettings()) continue;
            ret = false;
        }
        return ret;
    }

    public void addProvider(String name, SettingProvider provider, int priority) {
        LogUtil.info(this.getClass(), "Adding setting provider {0}, priority {1}.", provider, new Integer(priority));
        if (!provider.loadSettings()) {
            return;
        }
        ProviderInfo newPI = new ProviderInfo(name, provider, priority);
        int n = this.providerInfoList.size();
        for (int i = 0; i < n; ++i) {
            ProviderInfo pi = (ProviderInfo)this.providerInfoList.get(i);
            if (pi.getProvider() == provider) {
                return;
            }
            if (pi.getPriority() <= priority) continue;
            this.providerInfoList.add(i, newPI);
            return;
        }
        this.providerInfoList.add(newPI);
    }

    public void clearProvider(String name) {
        Iterator it = this.providerInfoList.iterator();
        while (it.hasNext()) {
            ProviderInfo pi = (ProviderInfo)it.next();
            if (!pi.getName().equals(name)) continue;
            it.remove();
            return;
        }
    }

    public SettingProvider getProvider(String name) {
        int n = this.providerInfoList.size();
        for (int i = 0; i < n; ++i) {
            ProviderInfo pi = (ProviderInfo)this.providerInfoList.get(i);
            if (!pi.getName().equals(name)) continue;
            return pi.getProvider();
        }
        return null;
    }

    public List getProviderInfoList() {
        return this.providerInfoList;
    }
}

