/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string;

import org.openbp.common.string.StringUtil;

public final class NameUtil {
    private NameUtil() {
    }

    public static String makeDisplayName(String name) {
        boolean isUpper;
        if (name == null) {
            return null;
        }
        int l = name.length();
        boolean bl = isUpper = l > 1 && NameUtil.isUpperCase(name);
        if (isUpper && name.indexOf(95) < 0) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l; ++i) {
            char c = name.charAt(i);
            if (isUpper) {
                if (c == '_') {
                    if (i <= 0) continue;
                    sb.append(' ');
                    continue;
                }
                if (i > 0) {
                    c = Character.toLowerCase(c);
                }
            } else {
                if (i > 0) {
                    if (Character.isUpperCase(c)) {
                        sb.append(' ');
                        c = Character.toLowerCase(c);
                    }
                } else if (Character.isLowerCase(c)) {
                    c = Character.toUpperCase(c);
                }
                if (c == '_') {
                    c = ' ';
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String makeMemberName(String name) {
        return StringUtil.decapitalize(name);
    }

    public static String makeXMLName(String name) {
        if (name == null) {
            return null;
        }
        int l = name.length();
        boolean isUpper = l > 1 && NameUtil.isUpperCase(name);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l; ++i) {
            char c = name.charAt(i);
            if (isUpper) {
                if (c == '_') {
                    if (i <= 0) continue;
                    sb.append('-');
                    continue;
                }
                c = Character.toLowerCase(c);
            } else {
                if (Character.isUpperCase(c)) {
                    if (i > 0) {
                        sb.append('-');
                    }
                    c = Character.toLowerCase(c);
                }
                if (c == '_') {
                    c = '-';
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(String name) {
        int l = name.length();
        for (int i = 0; i < l; ++i) {
            char c = name.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }
}

