/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string.parser;

import java.util.ArrayList;
import java.util.List;
import org.openbp.common.string.parser.StringParserException;

public class StringParser {
    private static StringBuffer tempBuffer = new StringBuffer();
    private static List emptyList = new ArrayList();
    private String str;
    private int length;
    private int index;
    private int line;
    private String errorFileName;
    private String extraIdentifierChars;

    public StringParser(String strArg) {
        this.reInit(strArg);
    }

    public String getExtraIdentifierChars() {
        return this.extraIdentifierChars;
    }

    public void setExtraIdentifierChars(String extraIdentifierChars) {
        this.extraIdentifierChars = extraIdentifierChars;
    }

    public void reInit(String str) {
        this.str = str;
        this.length = str.length();
        this.line = 1;
        this.index = 0;
    }

    public void setFileName(String errorFileName) {
        this.errorFileName = errorFileName;
    }

    public char getChar() {
        return this.index < this.length ? this.str.charAt(this.index) : (char)'\u0000';
    }

    public char getChar(int i) {
        return (i += this.index) < this.length ? this.str.charAt(i) : (char)'\u0000';
    }

    public void nextChar() {
        if (this.getChar() == '\n') {
            ++this.line;
        }
        ++this.index;
    }

    public void nextChar(int n) {
        while (n-- > 0 && this.index < this.length) {
            if (this.str.charAt(this.index) == '\n') {
                ++this.line;
            }
            ++this.index;
        }
    }

    public void rewindChar() {
        if (this.index > 0) {
            --this.index;
            if (this.getChar() == '\n') {
                --this.line;
            }
        }
    }

    public void rewindChar(int n) {
        while (n-- > 0 && this.index > 0) {
            --this.index;
            if (this.str.charAt(this.index) != '\n') continue;
            --this.line;
        }
    }

    public void skipSpace() {
        while (this.index < this.length) {
            char c = this.str.charAt(this.index);
            if (c == '\n') {
                ++this.line;
            }
            if (!Character.isWhitespace(c)) break;
            ++this.index;
        }
    }

    public void skipNoNewlineSpace() {
        while (this.index < this.length) {
            char c = this.str.charAt(this.index);
            if (c == '\n') {
                ++this.line;
            }
            if (c != ' ' && c != '\t') break;
            ++this.index;
        }
    }

    public boolean skipAssignmentOperator(String ident) {
        this.skipSpace();
        if (this.isEnd() || this.getChar() != '=') {
            this.printError("'=' exspected after " + ident);
            return false;
        }
        this.nextChar();
        this.skipSpace();
        return true;
    }

    public boolean isEnd() {
        return this.index >= this.length;
    }

    public int getPos() {
        return this.index;
    }

    public void setPos(int pos) {
        this.index = pos;
    }

    public void restorePos(int pos) {
        while (this.index > pos) {
            --this.index;
            char c = this.getChar();
            if (c != '\n') continue;
            --this.line;
        }
    }

    public int getLength() {
        return this.length;
    }

    public String getFileName() {
        return this.errorFileName;
    }

    public int getLineNr() {
        return this.line;
    }

    public void setLineNr(int line) {
        this.line = line;
    }

    public String getUntilEndOfLine() {
        char c;
        tempBuffer.setLength(0);
        while (this.index < this.length && (c = this.getChar()) != '\n' && c != '\r') {
            tempBuffer.append(c);
            this.nextChar();
        }
        while (this.index < this.length && ((c = this.getChar()) == '\n' || c == '\r')) {
            this.nextChar();
        }
        return tempBuffer.toString();
    }

    public String getIdentifier() {
        this.skipSpace();
        char c = this.getChar();
        if (!Character.isLetter(c) && c != '_') {
            return null;
        }
        tempBuffer.setLength(0);
        tempBuffer.append(c);
        this.nextChar();
        while (this.index < this.length && (Character.isLetterOrDigit(c = this.getChar()) || c == '_' || this.extraIdentifierChars != null && this.extraIdentifierChars.indexOf(c) != -1)) {
            tempBuffer.append(c);
            this.nextChar();
        }
        return tempBuffer.toString();
    }

    public String getQualifiedIdentifier() {
        this.skipSpace();
        char c = this.getChar();
        if (!Character.isLetter(c) && c != '_') {
            return null;
        }
        tempBuffer.setLength(0);
        tempBuffer.append(c);
        this.nextChar();
        while (this.index < this.length && (Character.isLetterOrDigit(c = this.getChar()) || c == '_' || c == '.' || this.extraIdentifierChars != null && this.extraIdentifierChars.indexOf(c) != -1)) {
            tempBuffer.append(c);
            this.nextChar();
        }
        return tempBuffer.toString();
    }

    public String getNonWhitespace() {
        this.skipSpace();
        char c = this.getChar();
        if (c == '\u0000' || Character.isWhitespace(c)) {
            return null;
        }
        tempBuffer.setLength(0);
        tempBuffer.append(c);
        this.nextChar();
        while (this.index < this.length && !Character.isWhitespace(c = this.getChar())) {
            tempBuffer.append(c);
            this.nextChar();
        }
        return tempBuffer.toString();
    }

    public String getNumber() {
        this.skipSpace();
        char c = this.getChar();
        if (!Character.isDigit(c)) {
            return null;
        }
        tempBuffer.setLength(0);
        tempBuffer.append(c);
        this.nextChar();
        while (this.index < this.length && Character.isDigit(c = this.getChar())) {
            tempBuffer.append(c);
            this.nextChar();
        }
        return tempBuffer.toString();
    }

    public String getOptionArgument() {
        char c = this.getChar();
        String value = c == '\"' || c == '\'' ? this.getString('\u0000') : this.str.substring(this.index);
        return value;
    }

    public String getString(char delimChar) {
        boolean htmlQuote = false;
        tempBuffer.setLength(0);
        this.skipSpace();
        char c = this.getChar();
        char cEnd = '\u0000';
        if (c == '\"') {
            cEnd = c;
            this.nextChar();
        } else if (c == '\'') {
            cEnd = c;
            this.nextChar();
        } else if (this.str.startsWith("&quot;", this.index)) {
            htmlQuote = true;
            this.index += 6;
        } else {
            return null;
        }
        if (delimChar != '\u0000') {
            tempBuffer.append(delimChar);
        }
        boolean escape = false;
        while (this.index < this.length) {
            c = this.getChar();
            if (!escape) {
                if (htmlQuote) {
                    if (this.str.startsWith("&quot;", this.index)) {
                        this.index += 6;
                        break;
                    }
                } else if (c == cEnd) {
                    this.nextChar();
                    break;
                }
            }
            if (c == '\\') {
                escape = true;
            } else {
                escape = false;
                tempBuffer.append(c);
            }
            this.nextChar();
        }
        if (delimChar != '\u0000') {
            tempBuffer.append(delimChar);
        }
        return tempBuffer.toString();
    }

    public List getOptionalParameters() {
        int savIndex = this.index;
        this.skipSpace();
        if (this.getChar() != '(') {
            this.index = savIndex;
            return null;
        }
        this.nextChar();
        this.skipSpace();
        if (this.getChar() == ')') {
            this.nextChar();
            return emptyList;
        }
        ArrayList<String> list = new ArrayList<String>();
        tempBuffer.setLength(0);
        while (this.index < this.length) {
            char c = this.getChar();
            if (c == ',' || c == ')') {
                int j;
                for (j = tempBuffer.length() - 1; j >= 0 && tempBuffer.charAt(j) == ' '; --j) {
                }
                if (j < 0) {
                    this.throwError("Invalid argument");
                }
                tempBuffer.setLength(j + 1);
                list.add(tempBuffer.toString());
                this.nextChar();
                if (c == ',') {
                    this.skipSpace();
                }
                tempBuffer.setLength(0);
                if (c != ')') continue;
                return list;
            }
            tempBuffer.append(Character.isWhitespace(c) ? (char)' ' : (char)c);
            this.nextChar();
        }
        this.throwError("Missing ')'");
        return null;
    }

    public boolean startsWith(String pattern) {
        return this.str.startsWith(pattern, this.index);
    }

    public void skipUntil(String pattern, boolean skipPattern) {
        while (this.index < this.length) {
            if (this.str.startsWith(pattern, this.index)) {
                if (skipPattern) {
                    this.index += pattern.length();
                }
                return;
            }
            this.nextChar();
        }
        this.throwError("Missing '" + pattern + '\'');
    }

    public String substring(int begin, int end) {
        return this.str.substring(begin, end);
    }

    public String substring(int begin) {
        return this.str.substring(begin);
    }

    public String substring() {
        return this.str.substring(this.index);
    }

    public void throwError(String msg) {
        throw new StringParserException(this.errorMsg(msg), this.getFileName(), this.getLineNr());
    }

    public void printError(String msg) {
        System.err.println(this.errorMsg(msg));
    }

    public String getSourceString() {
        return this.str;
    }

    public String errorMsg(String msg) {
        tempBuffer.setLength(0);
        if (this.errorFileName != null) {
            tempBuffer.append(this.errorFileName);
            tempBuffer.append("(");
            tempBuffer.append(this.line);
            tempBuffer.append("): ");
        }
        tempBuffer.append(msg);
        return tempBuffer.toString();
    }
}

