/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string.shellmatcher;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openbp.common.ReflectUtil;
import org.openbp.common.string.StringUtil;
import org.openbp.common.string.shellmatcher.ShellMatcher;
import org.openbp.common.string.shellmatcher.ShellMatcherException;

public class MultiPattern
implements Serializable {
    private String attributeName;
    private List patternValues = new ArrayList();
    private boolean exactMatch = false;
    private transient String methodName;

    public MultiPattern() {
    }

    public MultiPattern(String attributeName, Object patternValue) {
        this.setAttributeName(attributeName);
        this.addPatternValue(patternValue);
    }

    public boolean match(Object o) {
        int nPatterns = this.patternValues.size();
        if (this.methodName != null) {
            this.methodName = nPatterns > 0 && this.patternValues.get(0) instanceof Boolean ? "is" : "get";
            this.methodName = this.methodName + StringUtil.capitalize(this.attributeName);
        }
        Class<?> cls = o.getClass();
        try {
            Method method = cls.getMethod(this.methodName, null);
            Object value = method.invoke(o, (Object[])null);
            for (int i = 0; i < nPatterns; ++i) {
                if (this.matchValue(value, this.patternValues.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (NoSuchMethodException nsme) {
            throw new ShellMatcherException("Cannot find method '" + this.methodName + "' in class '" + ReflectUtil.getPrintableClassName(cls) + "'");
        }
        catch (IllegalAccessException iae) {
            throw new ShellMatcherException("Cannot execute method '" + this.methodName + "' in class '" + ReflectUtil.getPrintableClassName(cls) + "'");
        }
        catch (InvocationTargetException iae) {
            throw new ShellMatcherException("Error executing method '" + this.methodName + "' in class '" + ReflectUtil.getPrintableClassName(cls) + "'");
        }
    }

    private boolean matchValue(Object value, Object patternValue) {
        if (value == null && patternValue == null) {
            return true;
        }
        if (patternValue == null || value == null) {
            return false;
        }
        if (value instanceof String) {
            String valueString = (String)value;
            if (patternValue instanceof String) {
                return this.matchString(valueString, (String)patternValue);
            }
            if (patternValue instanceof ShellMatcher) {
                ShellMatcher matcher = (ShellMatcher)patternValue;
                return matcher.match(valueString);
            }
            return false;
        }
        return value.equals(patternValue);
    }

    private boolean matchString(String value, String pattern) {
        if (this.exactMatch) {
            return value.equalsIgnoreCase(pattern);
        }
        int vl = value.length();
        int pl = pattern.length();
        int max = vl - pl;
        for (int i = 0; i <= max; ++i) {
            if (!value.regionMatches(true, i, pattern, 0, pl)) continue;
            return true;
        }
        return false;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void addPatternValue(Object patternValue) {
        String s;
        if (patternValue instanceof String && this.isPattern(s = (String)patternValue)) {
            ShellMatcher matcher = new ShellMatcher(s);
            matcher.setIgnoreCase(true);
            this.addPatternValue(matcher);
            return;
        }
        this.addPatternValue(patternValue);
    }

    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    private boolean isPattern(String s) {
        boolean escape = false;
        int l = s.length();
        block4: for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    escape = !escape;
                    continue block4;
                }
                case '*': 
                case '?': 
                case '[': {
                    if (!escape) {
                        return true;
                    }
                }
                default: {
                    escape = false;
                }
            }
        }
        return false;
    }
}

