/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string.shellmatcher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openbp.common.CollectionUtil;
import org.openbp.common.string.StringUtil;
import org.openbp.common.string.shellmatcher.ShellFilenameFilter;

public class ShellList {
    private List fileList = new ArrayList();

    public void expandPattern(String pattern) {
        this.expandPattern(pattern, true);
    }

    public void clearFiles() {
        this.fileList.clear();
    }

    public String[] getFiles() {
        return CollectionUtil.toStringArray(this.fileList);
    }

    public int getFileCount() {
        return this.fileList.size();
    }

    private void expandPattern(String fileName, boolean first) {
        String remainder;
        fileName = StringUtil.normalizePathName(fileName);
        StringBuffer dirBuf = new StringBuffer();
        StringBuffer patternBuf = new StringBuffer();
        StringBuffer remainderBuf = new StringBuffer();
        ShellList.splitPath(fileName, dirBuf, patternBuf, remainderBuf);
        String dir = dirBuf.length() == 0 ? null : dirBuf.toString();
        String pattern = patternBuf.length() == 0 ? null : patternBuf.toString();
        String string = remainder = remainderBuf.length() == 0 ? null : remainderBuf.toString();
        if (dir != null) {
            File dirFile = new File(dir);
            boolean dirExists = dirFile.exists();
            if (pattern == null && (first || dirExists)) {
                this.fileList.add(dir);
            }
            if (!dirExists) {
                return;
            }
        }
        if (pattern == null) {
            return;
        }
        String[] dirFiles = this.getFileList(dir, pattern);
        if (dirFiles == null) {
            return;
        }
        for (int i = 0; i < dirFiles.length; ++i) {
            String s = dirFiles[i];
            String path = dir != null ? dir + '/' + s : s;
            if (remainder == null) {
                this.fileList.add(path);
                continue;
            }
            File pathFile = new File(path);
            if (!pathFile.isDirectory()) continue;
            path = dir != null ? dir + '/' + s + '/' + remainder : s + '/' + remainder;
            this.expandPattern(path, false);
        }
    }

    public void expandDirectory(String dirName, String pattern) {
        File dir;
        String[] dirFiles = this.getFileList(dirName = StringUtil.normalizeDir(dirName), pattern);
        if (dirFiles != null) {
            for (int i = 0; i < dirFiles.length; ++i) {
                File file;
                String s = dirFiles[i];
                if (dirName != null) {
                    s = dirName + '/' + s;
                }
                if ((file = new File(s)).isDirectory()) continue;
                this.fileList.add(s);
            }
        }
        if ((dirFiles = (dir = new File(dirName)).list()) == null) {
            return;
        }
        for (int i = 0; i < dirFiles.length; ++i) {
            File file;
            String s = dirFiles[i];
            if (dirName != null) {
                s = dirName + '/' + s;
            }
            if (!(file = new File(s)).isDirectory()) continue;
            this.expandDirectory(s, pattern);
        }
    }

    private String[] getFileList(String dirName, String pattern) {
        File d = new File(dirName != null ? dirName : ".");
        ShellFilenameFilter sff = new ShellFilenameFilter(pattern);
        sff.setIgnoreCase(true);
        String[] files = d.list(sff);
        return files;
    }

    public static void splitPath(String path, StringBuffer dir, StringBuffer pattern, StringBuffer remainder) {
        char c;
        int iPat;
        path = StringUtil.normalizePathName(path);
        dir.setLength(0);
        pattern.setLength(0);
        remainder.setLength(0);
        int lPath = path.length();
        for (iPat = 0; iPat < lPath && (c = path.charAt(iPat)) != '*' && c != '?' && c != '['; ++iPat) {
        }
        if (iPat == lPath) {
            dir.append(path);
            return;
        }
        int iSep1 = path.lastIndexOf(47, iPat);
        if (iSep1 == 0) {
            dir.append('/');
        } else if (iSep1 > 0) {
            dir.append(path.substring(0, iSep1));
        }
        int iSep2 = path.indexOf(47, iPat);
        if (iSep2 >= 0) {
            remainder.append(path.substring(iSep2 + 1));
        }
        String s = null;
        s = iSep1 >= 0 ? (iSep2 >= 0 ? path.substring(iSep1 + 1, iSep2) : path.substring(iSep1 + 1)) : (iSep2 >= 0 ? path.substring(0, iSep2) : path.substring(0));
        pattern.append(s);
    }
}

