/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.string.shellmatcher;

import org.openbp.common.string.shellmatcher.ShellMatcherException;

public class ShellMatcher {
    private String pattern;
    private String str;
    private boolean ignoreCase;
    private int pl;
    private int sl;

    public ShellMatcher() {
    }

    public ShellMatcher(String patternArg) {
        this.setPattern(patternArg);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.pl = pattern != null ? pattern.length() : 0;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean match(String s) {
        if (s == null) {
            throw new ShellMatcherException("Invalid string argument");
        }
        if (this.pattern == null) {
            throw new ShellMatcherException("Invalid pattern argument");
        }
        this.str = s;
        this.sl = this.str.length();
        return this.match(0, 0);
    }

    private boolean match(int si, int pi) {
        boolean inclusive = false;
        while (true) {
            char sc;
            char pc;
            char c = pc = pi < this.pl ? this.pattern.charAt(pi) : (char)'\u0000';
            if (si < this.sl) {
                sc = this.str.charAt(si);
                if (this.ignoreCase) {
                    sc = Character.toLowerCase(sc);
                }
            } else {
                sc = '\u0000';
            }
            block0 : switch (pc) {
                case '\u0000': {
                    return sc == '\u0000';
                }
                case '?': {
                    if (sc != '\u0000') break;
                    return false;
                }
                case '[': {
                    inclusive = true;
                    while (true) {
                        if ((pc = this.getPatternChar(++pi)) == ']') {
                            if (!inclusive) break block0;
                            return false;
                        }
                        if (pc == '^') {
                            inclusive = false;
                            continue;
                        }
                        if (pc == '-') {
                            char pc2 = this.pattern.charAt(pi - 1);
                            if (pc2 == '[') {
                                throw new ShellMatcherException("Syntax error in pattern, pos " + pi);
                            }
                            if ((pc = this.getPatternChar(++pi)) == ']') {
                                return false;
                            }
                            if (sc >= pc2 && sc <= pc) {
                                if (inclusive) {
                                    while ((pc = this.getPatternChar(++pi)) != ']') {
                                    }
                                    break block0;
                                }
                                return false;
                            }
                            if (!inclusive) continue;
                            return false;
                        }
                        if (sc == pc) break;
                    }
                    if (!inclusive) {
                        return false;
                    }
                    while ((pc = this.getPatternChar(++pi)) != ']') {
                    }
                    break;
                }
                case '*': {
                    ++pi;
                    while (sc != '\u0000') {
                        if (this.match(si++, pi)) {
                            return true;
                        }
                        sc = si < this.sl ? this.str.charAt(si) : (char)'\u0000';
                    }
                    return pi >= this.pl;
                }
                case '\\': {
                    pc = this.getPatternChar(++pi);
                }
                default: {
                    if (sc == pc || this.ignoreCase && sc == Character.toLowerCase(pc)) break;
                    return false;
                }
            }
            ++si;
            ++pi;
        }
    }

    private char getPatternChar(int pi) {
        if (pi >= this.pl) {
            throw new ShellMatcherException("Syntax error in pattern, pos " + pi);
        }
        char c = this.pattern.charAt(pi);
        if (this.ignoreCase) {
            c = Character.toLowerCase(c);
        }
        return c;
    }
}

