/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

public final class ByteArrayUtil {
    private static final String[] b2h = new String[256];

    private ByteArrayUtil() {
    }

    public static byte[] replaceBytes(byte[] bytes, byte[] pattern, byte[] replacement) {
        int index = ByteArrayUtil.findPattern(bytes, pattern);
        if (index < 0) {
            return bytes;
        }
        byte[] result = new byte[bytes.length - pattern.length + replacement.length];
        System.arraycopy(bytes, 0, result, 0, index);
        System.arraycopy(replacement, 0, result, index, replacement.length);
        int remaining = bytes.length - index - pattern.length;
        System.arraycopy(bytes, index + pattern.length, result, index + replacement.length, remaining);
        return result;
    }

    private static int findPattern(byte[] bytes, byte[] pattern) {
        int n = bytes.length - pattern.length;
        for (int i = 0; i < n; ++i) {
            if (!ByteArrayUtil.matchPattern(bytes, i, pattern)) continue;
            return i;
        }
        return -1;
    }

    private static boolean matchPattern(byte[] bytes, int bytesOffset, byte[] pattern) {
        int n = pattern.length;
        for (int i = 0; i < n; ++i) {
            if (bytes[bytesOffset + i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public static String toHexString(byte b) {
        return b2h[b & 0xFF];
    }

    public static String toHexString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            ret.append((i > 0 ? "," : "") + ByteArrayUtil.toHexString(b[i]));
        }
        return ret.toString();
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return "null";
        }
        if (b.length == 0) {
            return "empty";
        }
        StringBuilder ret = new StringBuilder(b.length * 4);
        ret.append("[");
        for (int i = 0; i < b.length; ++i) {
            ret.append(ByteArrayUtil.toHexString(b[i]));
            if (i >= b.length - 1) continue;
            ret.append(", ");
        }
        ret.append("]");
        return ret.toString().toUpperCase();
    }

    public static String toShortHexString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (byte element : b) {
            ret.append(ByteArrayUtil.toHexString(element));
        }
        return ret.toString();
    }

    public static byte[] fromShortHexString(String hex) throws IllegalArgumentException {
        if (hex == null) {
            return null;
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex strings must have even length");
        }
        char[] carr = hex.toCharArray();
        byte[] ret = new byte[hex.length() / 2];
        for (int pos = 0; pos < ret.length; ++pos) {
            ret[pos] = (byte)(ByteArrayUtil.dehex(carr[pos * 2]) << 4 | ByteArrayUtil.dehex(carr[pos * 2 + 1]));
        }
        return ret;
    }

    public static byte fromHex(String hex) throws IllegalArgumentException {
        if (hex == null) {
            throw new IllegalArgumentException("Hex strings may not be null");
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex strings must have length 2");
        }
        return (byte)(ByteArrayUtil.dehex(hex.charAt(0)) << 4 | ByteArrayUtil.dehex(hex.charAt(1)));
    }

    private static int dehex(char c) throws IllegalArgumentException {
        int v = Character.digit(c, 16);
        if (v == -1) {
            throw new IllegalArgumentException("'" + c + "' is no valid hex digit");
        }
        return v;
    }

    public static String toGroupedShortHexString(byte[] b) {
        if (b == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            ret.append(ByteArrayUtil.toHexString(b[i]));
            if ((i + 1) % 8 != 0) continue;
            ret.append(' ');
        }
        return ret.toString();
    }

    public static byte[] toBytes(long lp) {
        long l = lp;
        byte[] b = new byte[8];
        b[7] = (byte)l;
        b[6] = (byte)(l >>>= 8);
        b[5] = (byte)(l >>>= 8);
        b[4] = (byte)(l >>>= 8);
        b[3] = (byte)(l >>>= 8);
        b[2] = (byte)(l >>>= 8);
        b[1] = (byte)(l >>>= 8);
        b[0] = (byte)(l >>>= 8);
        return b;
    }

    static {
        for (int i = 0; i < b2h.length; ++i) {
            int highNibble = i >> 4 & 0xF;
            int lowNibble = i & 0xF;
            ByteArrayUtil.b2h[i] = (Integer.toHexString(highNibble) + Integer.toHexString(lowNibble)).toUpperCase();
        }
    }
}

