/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OrderedMap
extends HashMap {
    private List keyList;
    private Set keySet;

    public OrderedMap() {
    }

    public OrderedMap(int initialCapacity) {
        super(initialCapacity);
        this.keyList = new ArrayList(initialCapacity);
    }

    public Object getValue(int index) {
        return super.get(this.getKey(index));
    }

    public Object getKey(int index) {
        return this.keyList.get(index);
    }

    public int indexOf(Object key) {
        if (this.keyList == null) {
            return -1;
        }
        return this.keyList.indexOf(key);
    }

    public void removeLast() {
        if (this.keyList == null || this.keyList.isEmpty()) {
            return;
        }
        Object key = this.keyList.get(this.keyList.size() - 1);
        this.remove(key);
    }

    public Object getLastValue() {
        if (this.keyList == null || this.keyList.isEmpty()) {
            return null;
        }
        return this.getValue(this.size() - 1);
    }

    public Object getLastKey() {
        if (this.keyList == null || this.keyList.isEmpty()) {
            return null;
        }
        return this.getKey(this.size() - 1);
    }

    @Override
    public Object put(Object key, Object value) {
        if (this.keyList == null) {
            this.keyList = new ArrayList();
        }
        if (!this.keyList.contains(key)) {
            this.keyList.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (this.keyList != null) {
            this.keyList.remove(key);
        }
        return super.remove(key);
    }

    @Override
    public void clear() {
        if (this.keyList == null) {
            return;
        }
        this.keyList.clear();
    }

    @Override
    public Set keySet() {
        if (this.keyList == null) {
            return null;
        }
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection values() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        ArrayList list = new ArrayList(size);
        Iterator iterator = this.keyList.iterator();
        while (iterator.hasNext()) {
            list.add(this.get(iterator.next()));
        }
        return list;
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public void clear() {
            OrderedMap.this.clear();
        }

        @Override
        public Iterator iterator() {
            return OrderedMap.this.keyList.iterator();
        }

        @Override
        public boolean remove(Object o) {
            return OrderedMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return OrderedMap.this.keyList.size();
        }

        @Override
        public boolean contains(Object o) {
            return OrderedMap.this.containsKey(o);
        }
    }
}

